/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt.animation;

import edu.cmu.cs.dennisc.awt.animation.SubjectAsSeenByAnimation;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;
import edu.cmu.cs.dennisc.math.Point2f;
import java.awt.Component;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class PositionAnimation
extends SubjectAsSeenByAnimation {
    public static final Point2f USE_EXISTING_VALUE_AT_RUN_TIME = null;
    private Point2f m_posBegin = new Point2f();
    private Point2f m_posEnd = new Point2f();
    private Point2f m_posBeginUsedAtRuntime = new Point2f();
    private Point2f m_posRuntime = new Point2f();

    public PositionAnimation() {
        this.m_posBeginUsedAtRuntime.setNaN();
        this.m_posBegin.setNaN();
        this.m_posEnd.setNaN();
    }

    public PositionAnimation(Component awtSubject, Component awtAsSeenBy, Point2f posBegin, Point2f posEnd) {
        super(awtSubject, awtAsSeenBy);
        this.m_posBeginUsedAtRuntime.setNaN();
        this.setPositionBegin(posBegin);
        this.setPositionEnd(posEnd);
    }

    public Point2f accessPositionBeginUsedAtRuntime() {
        return this.m_posBeginUsedAtRuntime;
    }

    public Point2f getPositionBeginUsedAtRuntime(Point2f rv) {
        rv.set(this.m_posBeginUsedAtRuntime);
        return rv;
    }

    public Point2f getPositionBeginUsedAtRuntime() {
        return this.getPositionBeginUsedAtRuntime(new Point2f());
    }

    public Point2f accessPositionBegin() {
        return this.m_posBegin;
    }

    public Point2f getPositionBegin(Point2f rv) {
        rv.set(this.m_posBegin);
        return rv;
    }

    public Point2f getPositionBegin() {
        return this.getPositionBegin(new Point2f());
    }

    public void setPositionBegin(Point2f posBegin) {
        if (posBegin != USE_EXISTING_VALUE_AT_RUN_TIME) {
            this.m_posBegin.set(posBegin);
        } else {
            this.m_posBegin.setNaN();
        }
    }

    public Point2f accessPositionEnd() {
        return this.m_posEnd;
    }

    public Point2f getPositionEnd(Point2f rv) {
        rv.set(this.m_posEnd);
        return rv;
    }

    public Point2f getPositionEnd() {
        return this.getPositionEnd(new Point2f());
    }

    public void setPositionEnd(Point2f posEnd) {
        this.m_posEnd.set(posEnd);
    }

    public void prologue() {
        if (this.m_posBegin.isNaN()) {
            Point p = SwingUtilities.convertPoint(this.getSubject().getParent(), this.getSubject().getX(), this.getSubject().getY(), this.getAsSeenBy());
            this.m_posBeginUsedAtRuntime.set(p.x, p.y);
        } else {
            this.m_posBeginUsedAtRuntime.set(this.m_posBegin);
        }
    }

    public void setPortion(double portion) {
        InterpolationUtilities.interpolate(this.m_posRuntime, this.m_posBeginUsedAtRuntime, this.m_posEnd, (float)portion);
        Point p = SwingUtilities.convertPoint(this.getAsSeenBy(), (int)this.m_posRuntime.x, (int)this.m_posRuntime.y, this.getSubject().getParent());
        this.getSubject().setLocation(p);
    }

    public void epilogue() {
        Point p = SwingUtilities.convertPoint(this.getAsSeenBy(), (int)this.m_posEnd.x, (int)this.m_posEnd.y, this.getSubject().getParent());
        this.getSubject().setLocation(p);
        this.m_posBeginUsedAtRuntime.setNaN();
    }
}

