/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt.event;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class LenientMouseClickAdapter
implements MouseListener,
MouseMotionListener {
    private static final long CLICK_THRESHOLD_MILLIS = 1000L;
    private static final long CLICK_THRESHOLD_PIXELS_SQUARED = 25L;
    private boolean isStillClick = false;
    private boolean isStillUnclick = false;
    private MouseEvent ePressed = null;
    private MouseEvent eReleased = null;
    private int count = 0;

    protected abstract void mouseQuoteClickedUnquote(MouseEvent var1, int var2);

    private boolean isWithinThreshold(MouseEvent eThen, MouseEvent eNow) {
        if (eThen != null) {
            long whenDelta = eNow.getWhen() - eThen.getWhen();
            if (whenDelta < 1000L) {
                int yDelta;
                int xDelta = eNow.getX() - eThen.getX();
                int distanceSquared = xDelta * xDelta + (yDelta = eNow.getY() - eThen.getY()) * yDelta;
                return (long)distanceSquared <= 25L;
            }
            return false;
        }
        return false;
    }

    private void updateStillClick(MouseEvent eNow) {
        if (this.isStillClick) {
            this.isStillClick = this.isWithinThreshold(this.ePressed, eNow);
        }
    }

    private void updateStillUnclick(MouseEvent eNow) {
        if (this.isStillUnclick) {
            this.isStillUnclick = this.isWithinThreshold(this.eReleased, eNow);
        }
    }

    public final void mouseEntered(MouseEvent e) {
    }

    public final void mouseExited(MouseEvent e) {
    }

    public final void mousePressed(MouseEvent e) {
        this.updateStillUnclick(e);
        if (!this.isStillUnclick) {
            this.count = 0;
        }
        this.isStillClick = true;
        this.ePressed = e;
    }

    public final void mouseReleased(MouseEvent e) {
        this.updateStillClick(e);
        if (this.isStillClick) {
            ++this.count;
            this.mouseQuoteClickedUnquote(e, this.count);
        }
        this.isStillUnclick = true;
        this.eReleased = e;
    }

    public final void mouseClicked(MouseEvent e) {
    }

    public final void mouseMoved(MouseEvent e) {
        this.updateStillUnclick(e);
    }

    public final void mouseDragged(MouseEvent e) {
        this.updateStillClick(e);
    }
}

