/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt.event;

import edu.cmu.cs.dennisc.awt.event.InputEventUtilities;
import edu.cmu.cs.dennisc.lang.SystemUtilities;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class MouseEventUtilities {
    public static boolean isQuoteLeftUnquoteMouseButton(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (SystemUtilities.isMac()) {
                return !e.isControlDown();
            }
            return true;
        }
        return false;
    }

    public static boolean isQuoteRightUnquoteMouseButton(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return true;
        }
        if (SystemUtilities.isMac()) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                return e.isControlDown();
            }
            return false;
        }
        return false;
    }

    public static MouseEvent performPlatformFilter(MouseEvent original) {
        MouseEvent rv;
        if (SystemUtilities.isMac()) {
            int filteredModifiers;
            int completeModifiers = InputEventUtilities.getCompleteModifiers(original);
            if (completeModifiers == (filteredModifiers = InputEventUtilities.performPlatformModifiersFilter(completeModifiers))) {
                rv = original;
            } else {
                boolean isPopupTrigger = original.isPopupTrigger();
                rv = new MouseEvent(original.getComponent(), original.getID(), original.getWhen(), filteredModifiers, original.getX(), original.getY(), original.getClickCount(), isPopupTrigger);
            }
        } else {
            rv = original;
        }
        return rv;
    }
}

