/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.awt.geom;

import edu.cmu.cs.dennisc.awt.TextAlignment;
import edu.cmu.cs.dennisc.awt.geom.GraphicsContext;
import edu.cmu.cs.dennisc.awt.geom.TransformContext;
import edu.cmu.cs.dennisc.awt.geom.Transformable;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class MultilineText
extends Transformable {
    private edu.cmu.cs.dennisc.awt.MultilineText multilineText;
    private Font font;
    private TextAlignment alignment;
    private Paint paint;
    private float wrapWidth;

    public MultilineText(String text, Font font, TextAlignment alignment, Paint paint) {
        this.multilineText = new edu.cmu.cs.dennisc.awt.MultilineText(text);
        this.font = font;
        this.alignment = alignment;
        this.paint = paint;
        this.wrapWidth = Float.NaN;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public TextAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(TextAlignment alignment) {
        this.alignment = alignment;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public float getWrapWidth() {
        return this.wrapWidth;
    }

    public void setWrapWidth(float wrapWidth) {
        this.wrapWidth = wrapWidth;
    }

    public Rectangle2D getBounds(Graphics g) {
        Dimension2D size = this.multilineText.getDimension(g, this.wrapWidth);
        double width = size.getWidth();
        double height = size.getHeight();
        return new Rectangle2D.Double(-width * 0.5, -height * 0.5, width, height);
    }

    protected void paintComponent(GraphicsContext gc) {
        Graphics2D g2 = gc.getAWTGraphics2D();
        g2.setPaint(this.paint);
        Rectangle2D bounds = this.getBounds(g2);
        this.multilineText.paint(g2, this.wrapWidth, this.alignment, bounds);
    }

    protected Area update(Area rv, TransformContext tc) {
        return rv;
    }
}

