/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.codec;

import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.InputStreamBinaryDecoder;
import edu.cmu.cs.dennisc.codec.OutputStreamBinaryEncoder;
import edu.cmu.cs.dennisc.codec.ReferenceableBinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.equivalence.CaseSensitivityPolicy;
import edu.cmu.cs.dennisc.io.FileUtilities;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodecUtilities {
    private static final String DEFAULT_ZIP_ENTRY_NAME = "edu.cmu.cs.dennisc.codec.CodecUtilities.DEFAULT_ZIP_ENTRY_NAME";

    private CodecUtilities() {
    }

    public static <E extends BinaryEncodableAndDecodable> E decodeBinary(InputStream is, Class<E> cls) {
        InputStreamBinaryDecoder binaryDecoder = new InputStreamBinaryDecoder(is);
        return binaryDecoder.decodeBinaryEncodableAndDecodable(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E extends BinaryEncodableAndDecodable> E decodeBinary(File file, Class<E> cls) {
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                E e = CodecUtilities.decodeBinary(fis, cls);
                return e;
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static <E extends BinaryEncodableAndDecodable> E decodeBinary(String path, Class<E> cls) {
        if (FileUtilities.isExtensionAmoung(path, CaseSensitivityPolicy.INSENSITIVE, "zip")) {
            return CodecUtilities.decodeZippedBinary(path, DEFAULT_ZIP_ENTRY_NAME, cls);
        }
        return CodecUtilities.decodeBinary(new File(path), cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E extends BinaryEncodableAndDecodable> E decodeZippedBinary(ZipFile file, ZipEntry entry, Class<E> cls) {
        try {
            InputStream is = file.getInputStream(entry);
            try {
                E e = CodecUtilities.decodeBinary(is, cls);
                return e;
            }
            finally {
                is.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static <E extends BinaryEncodableAndDecodable> E decodeZippedBinary(String path, String entryName, Class<E> cls) {
        try {
            ZipFile file = new ZipFile(path);
            ZipEntry entry = file.getEntry(entryName);
            return CodecUtilities.decodeZippedBinary(file, entry, cls);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static BinaryEncodableAndDecodable decodeBinary(BinaryEncodableAndDecodable rv, InputStream is) {
        InputStreamBinaryDecoder binaryDecoder = new InputStreamBinaryDecoder(is);
        return binaryDecoder.decodeBinaryEncodableAndDecodable(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryEncodableAndDecodable decodeBinary(BinaryEncodableAndDecodable rv, File file) {
        BinaryEncodableAndDecodable binaryEncodableAndDecodable;
        FileInputStream fis = new FileInputStream(file);
        try {
            binaryEncodableAndDecodable = CodecUtilities.decodeBinary(rv, fis);
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        fis.close();
        return binaryEncodableAndDecodable;
    }

    public static BinaryEncodableAndDecodable decodeBinary(BinaryEncodableAndDecodable rv, String path) {
        if (FileUtilities.isExtensionAmoung(path, CaseSensitivityPolicy.INSENSITIVE, "zip")) {
            return CodecUtilities.decodeZippedBinary(rv, path, DEFAULT_ZIP_ENTRY_NAME);
        }
        return CodecUtilities.decodeBinary(rv, new File(path));
    }

    public static BinaryEncodableAndDecodable decodeBinary(BinaryEncodableAndDecodable rv, byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        return CodecUtilities.decodeBinary(rv, bais);
    }

    public static <E extends BinaryEncodableAndDecodable> E decodeBinary(byte[] data, Class<E> cls) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        return CodecUtilities.decodeBinary(bais, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryEncodableAndDecodable decodeZippedBinary(BinaryEncodableAndDecodable rv, ZipFile file, ZipEntry entry) {
        BinaryEncodableAndDecodable binaryEncodableAndDecodable;
        InputStream is = file.getInputStream(entry);
        try {
            binaryEncodableAndDecodable = CodecUtilities.decodeBinary(rv, is);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        is.close();
        return binaryEncodableAndDecodable;
    }

    public static BinaryEncodableAndDecodable decodeZippedBinary(BinaryEncodableAndDecodable rv, String path, String entryName) {
        try {
            ZipFile file = new ZipFile(path);
            ZipEntry entry = file.getEntry(entryName);
            return CodecUtilities.decodeZippedBinary(rv, file, entry);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable, OutputStream os) {
        OutputStreamBinaryEncoder binaryEncoder = new OutputStreamBinaryEncoder(os);
        binaryEncoder.encode(binaryEncodableAndDecodable);
        binaryEncoder.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable, File file) {
        FileUtilities.createParentDirectoriesIfNecessary(file);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                CodecUtilities.encodeBinary(binaryEncodableAndDecodable, fos);
            }
            finally {
                fos.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable, String path) {
        if (FileUtilities.isExtensionAmoung(path, CaseSensitivityPolicy.INSENSITIVE, "zip")) {
            CodecUtilities.encodeZippedBinary(binaryEncodableAndDecodable, path, DEFAULT_ZIP_ENTRY_NAME);
        } else {
            CodecUtilities.encodeBinary(binaryEncodableAndDecodable, new File(path));
        }
    }

    public static byte[] encodeBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodecUtilities.encodeBinary(binaryEncodableAndDecodable, baos);
        return baos.toByteArray();
    }

    public static void encodeZippedBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable, ZipOutputStream zos, ZipEntry entry) {
        try {
            zos.putNextEntry(entry);
            CodecUtilities.encodeBinary(binaryEncodableAndDecodable, zos);
            zos.closeEntry();
            zos.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeZippedBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable, OutputStream os, String entryName) {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(os));
        ZipEntry entry = new ZipEntry(entryName);
        CodecUtilities.encodeZippedBinary(binaryEncodableAndDecodable, zos, entry);
        try {
            zos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeZippedBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable, File file, String entryName) {
        FileUtilities.createParentDirectoriesIfNecessary(file);
        try {
            CodecUtilities.encodeZippedBinary(binaryEncodableAndDecodable, new FileOutputStream(file), entryName);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeZippedBinary(BinaryEncodableAndDecodable binaryEncodableAndDecodable, String path, String entryName) {
        CodecUtilities.encodeZippedBinary(binaryEncodableAndDecodable, new File(path), entryName);
    }

    public static <E extends ReferenceableBinaryEncodableAndDecodable> E decodeReferenceableBinary(InputStream is, Class<E> cls) {
        InputStreamBinaryDecoder binaryDecoder = new InputStreamBinaryDecoder(is);
        HashMap<Integer, ReferenceableBinaryEncodableAndDecodable> map = new HashMap<Integer, ReferenceableBinaryEncodableAndDecodable>();
        return binaryDecoder.decodeReferenceableBinaryEncodableAndDecodable(cls, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E extends ReferenceableBinaryEncodableAndDecodable> E decodeReferenceableBinary(File file, Class<E> cls) {
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                E e = CodecUtilities.decodeReferenceableBinary(fis, cls);
                return e;
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static <E extends ReferenceableBinaryEncodableAndDecodable> E decodeReferenceableBinary(String path, Class<E> cls) {
        if (FileUtilities.isExtensionAmoung(path, CaseSensitivityPolicy.INSENSITIVE, "zip")) {
            return CodecUtilities.decodeZippedReferenceableBinary(path, DEFAULT_ZIP_ENTRY_NAME, cls);
        }
        return CodecUtilities.decodeReferenceableBinary(new File(path), cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E extends ReferenceableBinaryEncodableAndDecodable> E decodeZippedReferenceableBinary(ZipFile file, ZipEntry entry, Class<E> cls) {
        try {
            InputStream is = file.getInputStream(entry);
            try {
                E e = CodecUtilities.decodeReferenceableBinary(is, cls);
                return e;
            }
            finally {
                is.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static <E extends ReferenceableBinaryEncodableAndDecodable> E decodeZippedReferenceableBinary(String path, String entryName, Class<E> cls) {
        try {
            ZipFile file = new ZipFile(path);
            ZipEntry entry = file.getEntry(entryName);
            return CodecUtilities.decodeZippedReferenceableBinary(file, entry, cls);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static ReferenceableBinaryEncodableAndDecodable decodeReferenceableBinary(ReferenceableBinaryEncodableAndDecodable rv, InputStream is) {
        InputStreamBinaryDecoder binaryDecoder = new InputStreamBinaryDecoder(is);
        HashMap<Integer, ReferenceableBinaryEncodableAndDecodable> map = new HashMap<Integer, ReferenceableBinaryEncodableAndDecodable>();
        return binaryDecoder.decodeReferenceableBinaryEncodableAndDecodable(rv, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceableBinaryEncodableAndDecodable decodeReferenceableBinary(ReferenceableBinaryEncodableAndDecodable rv, File file) {
        ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable;
        FileInputStream fis = new FileInputStream(file);
        try {
            referenceableBinaryEncodableAndDecodable = CodecUtilities.decodeReferenceableBinary(rv, fis);
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        fis.close();
        return referenceableBinaryEncodableAndDecodable;
    }

    public static ReferenceableBinaryEncodableAndDecodable decodeReferenceableBinary(ReferenceableBinaryEncodableAndDecodable rv, String path) {
        if (FileUtilities.isExtensionAmoung(path, CaseSensitivityPolicy.INSENSITIVE, "zip")) {
            return CodecUtilities.decodeZippedReferenceableBinary(rv, path, DEFAULT_ZIP_ENTRY_NAME);
        }
        return CodecUtilities.decodeReferenceableBinary(rv, new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceableBinaryEncodableAndDecodable decodeZippedReferenceableBinary(ReferenceableBinaryEncodableAndDecodable rv, ZipFile file, ZipEntry entry) {
        ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable;
        InputStream is = file.getInputStream(entry);
        try {
            referenceableBinaryEncodableAndDecodable = CodecUtilities.decodeReferenceableBinary(rv, is);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        is.close();
        return referenceableBinaryEncodableAndDecodable;
    }

    public static ReferenceableBinaryEncodableAndDecodable decodeZippedReferenceableBinary(ReferenceableBinaryEncodableAndDecodable rv, String path, String entryName) {
        try {
            ZipFile file = new ZipFile(path);
            ZipEntry entry = file.getEntry(entryName);
            return CodecUtilities.decodeZippedReferenceableBinary(rv, file, entry);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeReferenceableBinary(ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable, OutputStream os) {
        OutputStreamBinaryEncoder binaryEncoder = new OutputStreamBinaryEncoder(os);
        HashMap<ReferenceableBinaryEncodableAndDecodable, Integer> map = new HashMap<ReferenceableBinaryEncodableAndDecodable, Integer>();
        binaryEncoder.encode(referenceableBinaryEncodableAndDecodable, map);
        binaryEncoder.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeReferenceableBinary(ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable, File file) {
        FileUtilities.createParentDirectoriesIfNecessary(file);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                CodecUtilities.encodeReferenceableBinary(referenceableBinaryEncodableAndDecodable, fos);
            }
            finally {
                fos.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeReferenceableBinary(ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable, String path) {
        if (FileUtilities.isExtensionAmoung(path, CaseSensitivityPolicy.INSENSITIVE, "zip")) {
            CodecUtilities.encodeZippedReferenceableBinary(referenceableBinaryEncodableAndDecodable, path, DEFAULT_ZIP_ENTRY_NAME);
        } else {
            CodecUtilities.encodeReferenceableBinary(referenceableBinaryEncodableAndDecodable, new File(path));
        }
    }

    public static void encodeZippedReferenceableBinary(ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable, ZipOutputStream zos, ZipEntry entry) {
        try {
            zos.putNextEntry(entry);
            CodecUtilities.encodeReferenceableBinary(referenceableBinaryEncodableAndDecodable, zos);
            zos.closeEntry();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeZippedReferenceableBinary(ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable, OutputStream os, String entryName) {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(os));
        ZipEntry entry = new ZipEntry(entryName);
        CodecUtilities.encodeZippedReferenceableBinary(referenceableBinaryEncodableAndDecodable, zos, entry);
        try {
            zos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeZippedReferenceableBinary(ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable, File file, String entryName) {
        FileUtilities.createParentDirectoriesIfNecessary(file);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                CodecUtilities.encodeZippedReferenceableBinary(referenceableBinaryEncodableAndDecodable, fos, entryName);
            }
            finally {
                fos.flush();
                fos.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeZippedReferenceableBinary(ReferenceableBinaryEncodableAndDecodable referenceableBinaryEncodableAndDecodable, String path, String entryName) {
        CodecUtilities.encodeZippedReferenceableBinary(referenceableBinaryEncodableAndDecodable, new File(path), entryName);
    }
}

