/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.croquet;

import edu.cmu.cs.dennisc.awt.WindowUtilties;
import edu.cmu.cs.dennisc.zoot.InputValidator;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KInputPane<E>
extends JPanel {
    private List<InputValidator> m_validators = new LinkedList<InputValidator>();
    private JButton m_okButton;
    private JDialog m_dialog;
    private boolean m_isOK = false;

    public KInputPane() {
    }

    public KInputPane(InputValidator ... validators) {
        for (InputValidator validator : validators) {
            this.m_validators.add(validator);
        }
    }

    public void updateSizeIfNecessary() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (Component component : KInputPane.this.getComponents()) {
                    component.invalidate();
                }
                KInputPane.this.revalidate();
                if (KInputPane.this.m_dialog != null) {
                    Dimension actualSize = KInputPane.this.m_dialog.getSize();
                    Dimension preferredSize = KInputPane.this.m_dialog.getPreferredSize();
                    if (actualSize.width < preferredSize.width || actualSize.height < preferredSize.height) {
                        KInputPane.this.m_dialog.setSize(Math.max(actualSize.width, preferredSize.width), Math.max(actualSize.height, preferredSize.height));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOKButtonValidator(InputValidator validator) {
        List<InputValidator> list = this.m_validators;
        synchronized (list) {
            this.m_validators.add(validator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOKButtonValidator(InputValidator validator) {
        List<InputValidator> list = this.m_validators;
        synchronized (list) {
            this.m_validators.remove(validator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<InputValidator> getOKButtonValidators() {
        List<InputValidator> list = this.m_validators;
        synchronized (list) {
            return this.m_validators;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOKButtonValid() {
        List<InputValidator> list = this.m_validators;
        synchronized (list) {
            for (InputValidator validator : this.m_validators) {
                if (validator.isInputValid()) continue;
                return false;
            }
            return true;
        }
    }

    public void updateOKButton() {
        if (this.m_okButton != null) {
            this.m_okButton.setEnabled(this.isOKButtonValid());
        }
    }

    public void fireOKButtonIfPossible() {
        if (this.m_okButton != null && this.m_okButton.isEnabled()) {
            this.m_okButton.doClick();
        }
    }

    public void setOKButton(JButton okButton) {
        this.m_okButton = okButton;
        this.updateOKButton();
    }

    protected void setOK(boolean isOK) {
        this.m_isOK = isOK;
    }

    protected abstract E getActualInputValue();

    private final E getInputValue() {
        if (this.m_isOK) {
            return this.getActualInputValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E showInJDialog(Component ownerComponent, String title, boolean isModal) {
        Component root = SwingUtilities.getRoot(ownerComponent);
        final JDialog dialog = root instanceof Frame ? new JDialog((Frame)root) : (root instanceof Dialog ? new JDialog((Dialog)root) : new JDialog());
        dialog.setTitle(title);
        dialog.setModal(isModal);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class OKAction
        extends AbstractAction {
            public OKAction() {
                this.putValue("Name", "OK");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KInputPane.this.setOK(true);
                dialog.setVisible(false);
            }
        }
        JButton okButton = new JButton(new OKAction());
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CancelAction
        extends AbstractAction {
            public CancelAction() {
                this.putValue("Name", "Cancel");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KInputPane.this.setOK(false);
                dialog.setVisible(false);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        JPanel panel = new JPanel();
        panel.setBackground(this.getBackground());
        panel.add(okButton);
        if (this.isCancelDesired()) {
            panel.add(cancelButton);
        } else {
            dialog.setDefaultCloseOperation(0);
            dialog.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                    if (KInputPane.this.isDisposeDesired(e)) {
                        e.getWindow().dispose();
                    }
                }

                public void windowClosed(WindowEvent e) {
                }
            });
        }
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.getContentPane().add((Component)panel, "South");
        this.setOKButton(okButton);
        this.m_isOK = false;
        this.revalidate();
        dialog.pack();
        WindowUtilties.setLocationOnScreenToCenteredWithin(dialog, root);
        assert (this.m_dialog == null);
        this.m_dialog = dialog;
        try {
            E rv;
            this.m_dialog.setVisible(true);
            E e = rv = this.getInputValue();
            return e;
        }
        finally {
            this.setOKButton(null);
            this.m_dialog = null;
        }
    }

    protected boolean isDisposeDesired(WindowEvent e) {
        return true;
    }

    protected boolean isCancelDesired() {
        return true;
    }

    protected boolean isModalDefault() {
        return true;
    }

    public E showInJDialog(Component ownerComponent, String title) {
        return this.showInJDialog(ownerComponent, title, this.isModalDefault());
    }

    protected String getTitleDefault() {
        return null;
    }

    public E showInJDialog(Component ownerComponent) {
        return this.showInJDialog(ownerComponent, this.getTitleDefault());
    }
}

