/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.croquet.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ImageView
extends JComponent {
    private BufferedImage bufferedImage;
    private int desiredSize;

    public ImageView(BufferedImage bufferedImage, int desiredSize) {
        this.bufferedImage = bufferedImage;
        this.desiredSize = desiredSize;
    }

    public Dimension getPreferredSize() {
        if (this.bufferedImage != null) {
            int height;
            int width;
            double aspectRatio = (double)this.bufferedImage.getWidth() / (double)this.bufferedImage.getHeight();
            if ((double)this.bufferedImage.getWidth() > (double)this.bufferedImage.getHeight()) {
                width = this.desiredSize;
                height = (int)((double)width / aspectRatio);
            } else {
                height = this.desiredSize;
                width = (int)((double)height * aspectRatio);
            }
            return new Dimension(width, height);
        }
        return super.getPreferredSize();
    }

    protected void paintComponent(Graphics g) {
        if (this.bufferedImage != null) {
            Dimension preferredSize = this.getPreferredSize();
            int w = (int)preferredSize.getWidth();
            int h = (int)preferredSize.getHeight();
            int x = 0;
            int y = 0;
            g.drawImage(this.bufferedImage, x, y, x + w, y + h, 0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), this);
        }
    }
}

