/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.eula;

import edu.cmu.cs.dennisc.eula.LicenseRejectedException;
import edu.cmu.cs.dennisc.lang.SystemUtilities;
import edu.cmu.cs.dennisc.ui.eula.EULAPane;
import java.awt.Component;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class EULAUtilities
extends Exception {
    public static void promptUserToAcceptEULAIfNecessary(Class preferencesCls, String preferencesKey, String title, String license, String name) throws LicenseRejectedException {
        boolean isLicenseAccepted;
        Preferences userPreferences = Preferences.userNodeForPackage(preferencesCls);
        if (SystemUtilities.isPropertyTrue("org.alice.clearAllPreferences")) {
            try {
                userPreferences.clear();
            }
            catch (BackingStoreException bse) {
                throw new RuntimeException(bse);
            }
        }
        if (!(isLicenseAccepted = userPreferences.getBoolean(preferencesKey, false))) {
            String message;
            EULAPane pane = new EULAPane(license);
            Component owner = null;
            do {
                boolean bl = isLicenseAccepted = pane.showInJDialog(owner, title) == Boolean.TRUE;
            } while (!isLicenseAccepted && 0 == JOptionPane.showConfirmDialog(owner, message = "You must accept the license agreement in order to use " + name + ".\n\nWould you like to return to the license agreement?", "Return to license agreement?", 0));
        }
        if (!isLicenseAccepted) {
            throw new LicenseRejectedException();
        }
        userPreferences.putBoolean(preferencesKey, true);
    }
}

