/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.glyph;

import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.math.Point2f;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphVector {
    private String m_text;
    private Font m_font;
    private float m_xFactor;
    private float m_yFactor;
    public static final double FLATNESS = 0.01;
    private static FontRenderContext s_frc = new FontRenderContext(null, false, true);
    private static Stroke s_stroke = new BasicStroke(0.0f);
    private java.awt.font.GlyphVector m_glyphVector = null;
    private Shape m_facesShape = null;
    private Shape m_outlinesShape = null;
    private Vector<Vector<Point2f>> m_faceContours = null;
    private Vector<Vector<Point2f>> m_outlineLines = null;
    private Rectangle2D.Float m_bounds;

    public GlyphVector(String text, Font font, float xFactor, float yFactor) {
        this.m_text = text;
        this.m_font = font;
        this.m_xFactor = xFactor;
        this.m_yFactor = yFactor;
    }

    private void markShapesDirty() {
        this.m_glyphVector = null;
        this.m_facesShape = null;
        this.m_outlinesShape = null;
        this.m_outlineLines = null;
        this.m_faceContours = null;
        this.m_bounds = null;
    }

    private java.awt.font.GlyphVector getGlyphVector() {
        if (this.m_glyphVector == null) {
            this.m_glyphVector = this.m_font.createGlyphVector(s_frc, this.m_text);
        }
        return this.m_glyphVector;
    }

    public Shape getFacesShape() {
        if (this.m_facesShape == null) {
            java.awt.font.GlyphVector glyphVector = this.getGlyphVector();
            this.m_facesShape = glyphVector.getOutline();
        }
        return this.m_facesShape;
    }

    public Shape getOutlinesShape() {
        if (this.m_outlinesShape == null) {
            Shape facesShape = this.getFacesShape();
            this.m_outlinesShape = s_stroke.createStrokedShape(facesShape);
        }
        return this.m_outlinesShape;
    }

    private Vector<Vector<Point2f>> iterate(Shape shape) {
        PathIterator pi = shape.getPathIterator(null, 0.01);
        Vector<Vector<Point2f>> polylines = new Vector<Vector<Point2f>>();
        Vector<Point2f> polyline = null;
        float[] segment = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(segment)) {
                case 0: {
                    polyline = new Vector<Point2f>();
                }
                case 1: {
                    assert (polyline != null);
                    polyline.addElement(new Point2f(segment[0] * this.m_xFactor, segment[1] * this.m_yFactor));
                    break;
                }
                case 4: {
                    assert (polyline != null);
                    polylines.addElement(polyline);
                    polyline = null;
                    break;
                }
                case 2: {
                    throw new RuntimeException("SEG_QUADTO: should not occur when shape.getPathIterator is passed a flatness argument");
                }
                case 3: {
                    throw new RuntimeException("SEG_CUBICTO: should not occur when shape.getPathIterator is passed a flatness argument");
                }
                default: {
                    throw new RuntimeException("unhandled segment: should not occur");
                }
            }
            pi.next();
        }
        return polylines;
    }

    public Vector<Vector<Point2f>> acquireFaceContours() {
        if (this.m_faceContours == null) {
            this.m_faceContours = this.iterate(this.getFacesShape());
        }
        return this.m_faceContours;
    }

    public void releaseFaceContours() {
    }

    public Vector<Vector<Point2f>> acquireOutlineLines() {
        if (this.m_outlineLines == null) {
            this.m_outlineLines = this.iterate(this.getOutlinesShape());
        }
        return this.m_outlineLines;
    }

    public void releaseOutlineLines() {
    }

    public Rectangle2D.Float getBounds(Rectangle2D.Float rv) {
        if (this.m_bounds == null) {
            float xMin = Float.MAX_VALUE;
            float yMin = Float.MAX_VALUE;
            float xMax = -3.4028235E38f;
            float yMax = -3.4028235E38f;
            float[] segment = new float[6];
            PathIterator pi = this.getFacesShape().getPathIterator(null, 0.01);
            while (!pi.isDone()) {
                switch (pi.currentSegment(segment)) {
                    case 0: 
                    case 1: {
                        float xCurr = segment[0] * this.m_xFactor;
                        float yCurr = segment[1] * this.m_yFactor;
                        xMin = Math.min(xMin, xCurr);
                        xMax = Math.max(xMax, xCurr);
                        yMin = Math.min(yMin, yCurr);
                        yMax = Math.max(yMax, yCurr);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        throw new RuntimeException("SEG_QUADTO: should not occur when shape.getPathIterator is passed a flatness argument");
                    }
                    case 3: {
                        throw new RuntimeException("SEG_CUBICTO: should not occur when shape.getPathIterator is passed a flatness argument");
                    }
                    default: {
                        throw new RuntimeException("unhandled segment: should not occur");
                    }
                }
                pi.next();
            }
            this.m_bounds = xMin != Float.MAX_VALUE && yMin != Float.MAX_VALUE && xMax != -3.4028235E38f && yMax != -3.4028235E38f ? new Rectangle2D.Float(xMin, yMin, xMax - xMin, yMax - yMin) : new Rectangle2D.Float(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        }
        rv.setFrame(this.m_bounds);
        return rv;
    }

    public Rectangle2D.Float getBounds() {
        return this.getBounds(new Rectangle2D.Float());
    }

    public String getText() {
        return this.m_text;
    }

    public boolean setText(String text) {
        if (EquivalenceUtilities.areNotEquivalent(this.m_text, text)) {
            this.m_text = text;
            this.markShapesDirty();
            return true;
        }
        return false;
    }

    public Font getFont() {
        return this.m_font;
    }

    public boolean setFont(Font font) {
        if (EquivalenceUtilities.areNotEquivalent(this.m_font, font)) {
            this.m_font = font;
            this.markShapesDirty();
            return true;
        }
        return false;
    }
}

