/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.history;

import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.history.event.HistoryClearEvent;
import edu.cmu.cs.dennisc.history.event.HistoryInsertionIndexEvent;
import edu.cmu.cs.dennisc.history.event.HistoryListener;
import edu.cmu.cs.dennisc.history.event.HistoryPushEvent;
import edu.cmu.cs.dennisc.zoot.CompositeEdit;
import edu.cmu.cs.dennisc.zoot.Edit;
import edu.cmu.cs.dennisc.zoot.Operation;
import edu.cmu.cs.dennisc.zoot.ZManager;
import edu.cmu.cs.dennisc.zoot.event.CancelEvent;
import edu.cmu.cs.dennisc.zoot.event.CommitEvent;
import edu.cmu.cs.dennisc.zoot.event.ManagerListener;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryManager {
    private static ManagerListener managerListener = new ManagerListener(){

        public void operationCancelling(CancelEvent e) {
        }

        public void operationCancelled(CancelEvent e) {
        }

        public void operationCommitting(CommitEvent e) {
        }

        public void operationCommitted(CommitEvent e) {
            HistoryManager.handleOperationPerformed(e);
        }
    };
    private static Map<UUID, HistoryManager> map;
    private Stack<CommitEvent> stack = new Stack();
    private int insertionIndex = 0;
    private UUID uuid;
    private List<HistoryListener> historyListeners = new LinkedList<HistoryListener>();

    public static HistoryManager getInstance(UUID uuid) {
        HistoryManager rv = map.get(uuid);
        if (rv == null) {
            rv = new HistoryManager(uuid);
            map.put(uuid, rv);
        }
        return rv;
    }

    private static void handleOperationPerformed(CommitEvent commitEvent) {
        Edit edit = commitEvent.getEdit();
        if (edit != null) {
            Operation operation = (Operation)commitEvent.getTypedSource();
            HistoryManager historyManager = HistoryManager.getInstance(operation.getGroupUUID());
            historyManager.push(commitEvent);
        }
    }

    private HistoryManager(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Stack<CommitEvent> getStack() {
        return this.stack;
    }

    private void push(CommitEvent commitEvent) {
        Operation operation = (Operation)commitEvent.getTypedSource();
        if (EquivalenceUtilities.areEquivalent(operation.getGroupUUID(), this.uuid)) {
            HistoryPushEvent historyPushEvent = new HistoryPushEvent(this, commitEvent.getEdit());
            this.fireOperationPushing(historyPushEvent);
            this.stack.setSize(this.insertionIndex);
            this.stack.push(commitEvent);
            this.setInsertionIndex(this.stack.size(), false);
            this.fireOperationPushed(historyPushEvent);
        }
    }

    private static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private void undo() {
        if (this.insertionIndex > 0) {
            CommitEvent commitEvent = (CommitEvent)this.stack.get(this.insertionIndex - 1);
            if (commitEvent != null) {
                Edit edit = commitEvent.getEdit();
                if (edit.canUndo()) {
                    edit.undo();
                    --this.insertionIndex;
                } else {
                    HistoryManager.beep();
                }
            } else {
                HistoryManager.beep();
            }
        } else {
            HistoryManager.beep();
        }
    }

    private void redo() {
        if (this.insertionIndex < this.stack.size()) {
            CommitEvent commitEvent = (CommitEvent)this.stack.get(this.insertionIndex);
            if (commitEvent != null) {
                Edit edit = commitEvent.getEdit();
                if (edit != null) {
                    if (edit.canRedo()) {
                        edit.doOrRedo(false);
                        ++this.insertionIndex;
                    } else {
                        HistoryManager.beep();
                    }
                } else {
                    HistoryManager.beep();
                }
            } else {
                HistoryManager.beep();
            }
        } else {
            HistoryManager.beep();
        }
    }

    public void performClear() {
        HistoryClearEvent e = new HistoryClearEvent(this);
        this.fireClearing(e);
        this.stack.clear();
        this.insertionIndex = 0;
        this.fireCleared(e);
    }

    public void performUndo() {
        int nextIndex = this.insertionIndex - 1;
        int actualIndex = this.setInsertionIndex(nextIndex);
    }

    public void performRedo() {
        int nextIndex = this.insertionIndex + 1;
        int actualIndex = this.setInsertionIndex(nextIndex);
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    private int setInsertionIndex(int nextInsertionIndex, boolean isActionDesired) {
        if (nextInsertionIndex >= 0 && nextInsertionIndex <= this.stack.size() && this.insertionIndex != nextInsertionIndex) {
            HistoryInsertionIndexEvent e = new HistoryInsertionIndexEvent(this, this.insertionIndex, nextInsertionIndex);
            this.fireInsertionIndexChanging(e);
            int N = Math.abs(nextInsertionIndex - this.insertionIndex);
            if (nextInsertionIndex < this.insertionIndex) {
                for (int i = 0; i < N; ++i) {
                    if (isActionDesired) {
                        this.undo();
                        continue;
                    }
                    --this.insertionIndex;
                }
            } else {
                for (int i = 0; i < N; ++i) {
                    if (isActionDesired) {
                        this.redo();
                        continue;
                    }
                    ++this.insertionIndex;
                }
            }
            if (this.insertionIndex == nextInsertionIndex) {
                this.fireInsertionIndexChanged(e);
            }
        }
        return this.insertionIndex;
    }

    public int setInsertionIndex(int nextInsertionIndex) {
        return this.setInsertionIndex(nextInsertionIndex, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryListener(HistoryListener l) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            this.historyListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryListener(HistoryListener l) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            this.historyListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOperationPushing(HistoryPushEvent e) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            for (HistoryListener l : this.historyListeners) {
                l.operationPushing(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOperationPushed(HistoryPushEvent e) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            for (HistoryListener l : this.historyListeners) {
                l.operationPushed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertionIndexChanging(HistoryInsertionIndexEvent e) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            for (HistoryListener l : this.historyListeners) {
                l.insertionIndexChanging(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertionIndexChanged(HistoryInsertionIndexEvent e) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            for (HistoryListener l : this.historyListeners) {
                l.insertionIndexChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireClearing(HistoryClearEvent e) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            for (HistoryListener l : this.historyListeners) {
                l.clearing(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCleared(HistoryClearEvent e) {
        List<HistoryListener> list = this.historyListeners;
        synchronized (list) {
            for (HistoryListener l : this.historyListeners) {
                l.cleared(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeEdit createDoIgnoringCompositeEdit(String presentation) {
        Stack<CommitEvent> stack = this.stack;
        synchronized (stack) {
            int N = this.insertionIndex;
            if (N > 0) {
                Edit[] edits = new Edit[N];
                for (int i = 0; i < N; ++i) {
                    edits[i] = ((CommitEvent)this.stack.get(i)).getEdit();
                }
                return new CompositeEdit(edits, true, presentation);
            }
            return null;
        }
    }

    static {
        ZManager.addManagerListener(managerListener);
        map = new HashMap<UUID, HistoryManager>();
    }
}

