/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.history;

import edu.cmu.cs.dennisc.croquet.swing.BorderPane;
import edu.cmu.cs.dennisc.history.HistoryCellRenderer;
import edu.cmu.cs.dennisc.history.HistoryManager;
import edu.cmu.cs.dennisc.history.HistoryStackModel;
import edu.cmu.cs.dennisc.history.event.HistoryClearEvent;
import edu.cmu.cs.dennisc.history.event.HistoryInsertionIndexEvent;
import edu.cmu.cs.dennisc.history.event.HistoryListener;
import edu.cmu.cs.dennisc.history.event.HistoryPushEvent;
import java.awt.Dimension;
import java.util.UUID;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HistoryPane
extends BorderPane {
    private HistoryListener historyListener = new HistoryListener(){

        public void operationPushing(HistoryPushEvent e) {
        }

        public void operationPushed(HistoryPushEvent e) {
        }

        public void insertionIndexChanging(HistoryInsertionIndexEvent e) {
        }

        public void insertionIndexChanged(HistoryInsertionIndexEvent e) {
            HistoryPane.this.historyStackModel.refresh();
            HistoryPane.this.list.setSelectedIndex(e.getNextIndex());
            HistoryPane.this.list.repaint();
        }

        public void clearing(HistoryClearEvent e) {
        }

        public void cleared(HistoryClearEvent e) {
            HistoryPane.this.historyStackModel.refresh();
            HistoryPane.this.list.setSelectedIndex(0);
        }
    };
    private JList list = new JList();
    private HistoryStackModel historyStackModel;

    public HistoryPane(UUID uuid) {
        final HistoryManager historyManager = HistoryManager.getInstance(uuid);
        this.historyStackModel = new HistoryStackModel(historyManager);
        this.list.setModel(this.historyStackModel);
        this.list.setCellRenderer(new HistoryCellRenderer());
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    historyManager.setInsertionIndex(HistoryPane.this.list.getSelectedIndex());
                    HistoryPane.this.list.repaint();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add(scrollPane);
    }

    public void addNotify() {
        super.addNotify();
        this.historyStackModel.getHistoryManager().addHistoryListener(this.historyListener);
        this.list.setSelectedIndex(this.historyStackModel.getHistoryManager().getInsertionIndex());
    }

    public void removeNotify() {
        this.list.setSelectedIndex(-1);
        this.historyStackModel.getHistoryManager().removeHistoryListener(this.historyListener);
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        return new Dimension(240, 768);
    }
}

