/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.image.renderer;

import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;

public abstract class Renderer {
    private BufferedImage m_bufferedImage = null;

    protected void createBufferedImageIfNecessary(GraphicsConfiguration gc, int width, int height, int transparency) {
        if (this.m_bufferedImage != null && (this.m_bufferedImage.getWidth() < width || this.m_bufferedImage.getHeight() < height || this.m_bufferedImage.getTransparency() != transparency)) {
            this.m_bufferedImage = null;
        }
        if (this.m_bufferedImage == null) {
            this.m_bufferedImage = gc.createCompatibleImage(width, height, transparency);
        }
    }

    protected BufferedImage getBufferedImage() {
        return this.m_bufferedImage;
    }

    protected int getAllocatedWidth() {
        if (this.m_bufferedImage != null) {
            return this.m_bufferedImage.getWidth();
        }
        return 0;
    }

    protected int getAllocatedHeight() {
        if (this.m_bufferedImage != null) {
            return this.m_bufferedImage.getHeight();
        }
        return 0;
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract int getTransparency();

    public abstract void renderIntoBufferedImage(GraphicsConfiguration var1);

    public abstract void paintBackground(Graphics2D var1);

    public void paint(Graphics2D g2) {
        this.paint(g2, this.getWidth(), this.getHeight());
    }

    protected final void paint(Graphics2D g2, int width, int height) {
        this.paintBackground(g2);
        this.renderIntoBufferedImage(g2.getDeviceConfiguration());
        PrintUtilities.println("paint:", height, this.m_bufferedImage.getHeight());
        g2.drawImage(this.m_bufferedImage, 0, 0, width, height, null);
    }
}

