/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.io;

import edu.cmu.cs.dennisc.equivalence.CaseSensitivityPolicy;
import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilities {
    private static File s_defaultDirectory = null;

    public static File getDefaultDirectory() {
        if (s_defaultDirectory == null) {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            s_defaultDirectory = fileSystemView.getDefaultDirectory();
        }
        return s_defaultDirectory;
    }

    public static String getCanonicalPathIfPossible(File file) {
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException ioe) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public static String fixFilenameIfNecessary(String filename) {
        StringBuffer sb = new StringBuffer(filename.length());
        block3: for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            switch (c) {
                case '|': {
                    sb.append('_');
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isExtensionAmoung(String filename, CaseSensitivityPolicy caseSensitivityPolicy, String ... extensionCandidates) {
        String extension = FileUtilities.getExtension(filename);
        for (String extensionCandidate : extensionCandidates) {
            assert (extensionCandidate.charAt(0) != '.');
            if (!EquivalenceUtilities.areEquivalent(extension, extensionCandidate, caseSensitivityPolicy)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtensionAmoung(File file, CaseSensitivityPolicy caseSensitivityPolicy, String ... extensionCandidates) {
        return FileUtilities.isExtensionAmoung(file.getName(), caseSensitivityPolicy, extensionCandidates);
    }

    public static String getExtension(String filename) {
        int index;
        String extension = null;
        if (filename != null && (index = filename.lastIndexOf(46)) != -1) {
            extension = filename.substring(index + 1);
        }
        return extension;
    }

    public static String getExtension(File file) {
        if (file != null) {
            return FileUtilities.getExtension(file.getName());
        }
        return null;
    }

    public static String getBaseName(String filename) {
        String basename = null;
        if (filename != null) {
            int index = filename.lastIndexOf(46);
            basename = index != -1 ? filename.substring(0, index) : filename;
        }
        return basename;
    }

    public static String getBaseName(File file) {
        if (file != null) {
            return FileUtilities.getBaseName(file.getName());
        }
        return null;
    }

    public static boolean exists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean existsAndHasLengthGreaterThanZero(File file) {
        return file.exists() && file.length() > 0L;
    }

    public static boolean existsAndHasLengthGreaterThanZero(String path) {
        return FileUtilities.existsAndHasLengthGreaterThanZero(new File(path));
    }

    public static boolean createParentDirectoriesIfNecessary(File file) {
        return file.getParentFile().mkdirs();
    }

    public static boolean createParentDirectoriesIfNecessary(String path) {
        return FileUtilities.createParentDirectoriesIfNecessary(new File(path));
    }

    public static File getRelativeFile(File srcFile, int upCount, String ... childPaths) {
        File rv = srcFile;
        for (int i = 0; i < upCount; ++i) {
            rv = rv.getParentFile();
        }
        for (String childPath : childPaths) {
            rv = new File(rv, childPath);
        }
        return rv;
    }

    public static File getRelativeFile(File src, String ... childPaths) {
        return FileUtilities.getRelativeFile(src, 0, childPaths);
    }

    public static File getRelativeFile(String srcPath, int upCount, String ... childPaths) {
        return FileUtilities.getRelativeFile(new File(srcPath), upCount, childPaths);
    }

    public static File getRelativeFile(String srcPath, String ... childPaths) {
        return FileUtilities.getRelativeFile(srcPath, 0, childPaths);
    }

    public static File getAnalogousFile(File src, File srcRoot, File dstRoot) {
        String srcPath = src.getAbsolutePath();
        String srcRootPath = srcRoot.getAbsolutePath();
        assert (srcPath.startsWith(srcRootPath));
        String srcSubPath = srcPath.substring(srcRootPath.length());
        return new File(dstRoot, srcSubPath);
    }

    public static File getAnalogousFile(File src, File srcRoot, File dstRoot, String srcExtension, String dstExtension) {
        File f = FileUtilities.getAnalogousFile(src, srcRoot, dstRoot);
        File directory = f.getParentFile();
        String name = f.getName();
        assert (name.endsWith(srcExtension));
        return new File(directory, name.substring(0, name.length() - srcExtension.length()) + dstExtension);
    }

    public static File[] listFiles(File root, FileFilter fileFilter) {
        File[] rv = root.listFiles(fileFilter);
        if (rv == null) {
            rv = new File[]{};
        }
        return rv;
    }

    public static File[] listDirectories(File root) {
        return FileUtilities.listFiles(root, new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static File[] listDirectories(String rootPath) {
        return FileUtilities.listDirectories(new File(rootPath));
    }

    public static File[] listFiles(File root, String extension) {
        assert (extension.charAt(0) != '.');
        final String ext = extension;
        return FileUtilities.listFiles(root, new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && ext.equalsIgnoreCase(FileUtilities.getExtension(file));
            }
        });
    }

    public static File[] listFiles(String rootPath, String extension) {
        return FileUtilities.listFiles(new File(rootPath), extension);
    }

    private static Vector<File> updateDescendants(Vector<File> rv, File dir, FileFilter fileFilter) {
        File[] dirs;
        File[] files = dir.listFiles(fileFilter);
        if (files != null) {
            for (File childFile : files) {
                rv.add(childFile);
            }
        }
        if (files != (dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        }))) {
            for (File childDir : dirs) {
                FileUtilities.updateDescendants(rv, childDir, fileFilter);
            }
        }
        return rv;
    }

    public static File[] listDescendants(File root, FileFilter fileFilter) {
        Vector<File> v = FileUtilities.updateDescendants(new Vector<File>(), root, fileFilter);
        Object[] rv = new File[v.size()];
        v.copyInto(rv);
        return rv;
    }

    public static File[] listDescendants(String rootPath, FileFilter fileFilter) {
        return FileUtilities.listDescendants(new File(rootPath), fileFilter);
    }

    public static File[] listDescendants(File root, final String extension) {
        assert (root.exists()) : root;
        assert (extension.charAt(0) != '.');
        return FileUtilities.listDescendants(root, new FileFilter(){

            public boolean accept(File file) {
                if (file.isFile()) {
                    if (extension != null) {
                        return extension.equalsIgnoreCase(FileUtilities.getExtension(file));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static File[] listDescendants(String rootPath, String extension) {
        return FileUtilities.listDescendants(new File(rootPath), extension);
    }

    public static boolean isDescendantOf(File file, File possibleAncestor) {
        File parent;
        while ((parent = file.getParentFile()) != null) {
            if (parent.equals(possibleAncestor)) {
                return true;
            }
            file = parent;
        }
        return false;
    }

    public static boolean isAncestorOf(File file, File possibleDescendant) {
        return FileUtilities.isDescendantOf(possibleDescendant, file);
    }

    public static FilenameFilter createFilenameFilter(final String extension) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        };
    }

    public static FileFilter createFileFilter(final String extension) {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(extension);
            }
        };
    }

    public static void copyFile(File in, File out) throws IOException {
        FileUtilities.createParentDirectoriesIfNecessary(out);
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        inChannel.transferTo(0L, inChannel.size(), outChannel);
        inChannel.close();
        outChannel.close();
    }

    public static void copyFile(String inPath, String outPath) throws IOException {
        FileUtilities.copyFile(new File(inPath), new File(outPath));
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    FileUtilities.delete(f);
                }
            }
            boolean isSuccessful = file.delete();
            assert (isSuccessful) : file;
            assert (!file.exists()) : file;
        }
    }

    public static void delete(String path) {
        FileUtilities.delete(new File(path));
    }
}

