/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

public class TextFileUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader reader) {
        String string;
        String SEPARATOR = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            StringBuffer sb = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append(SEPARATOR);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        bufferedReader.close();
        return string;
    }

    public static String read(InputStream is) {
        return TextFileUtilities.read(new InputStreamReader(is));
    }

    public static String read(File file) {
        try {
            return TextFileUtilities.read(new FileReader(file));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String read(String path) {
        return TextFileUtilities.read(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Writer writer, String contents) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            try {
                bufferedWriter.write(contents);
                bufferedWriter.flush();
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void write(File file, String contents) {
        file.getParentFile().mkdirs();
        try {
            TextFileUtilities.write(new FileWriter(file), contents);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

