/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.javax.media.protocol;

import java.io.IOException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class ByteArraySeekablePullSourceStream
implements PullSourceStream,
Seekable {
    private static final ContentDescriptor RAW_CONTENT_DISCRIPTOR = new ContentDescriptor("raw");
    private byte[] data;
    private long location;

    public ByteArraySeekablePullSourceStream(byte[] data) {
        this.data = data;
        this.location = 0L;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        long bytesLeft = (long)this.data.length - this.location;
        if (bytesLeft == 0L) {
            return -1;
        }
        int intBytesLeft = (int)bytesLeft;
        int toRead = length;
        if (intBytesLeft < length) {
            toRead = intBytesLeft;
        }
        System.arraycopy(this.data, (int)this.location, buffer, offset, toRead);
        this.location += (long)toRead;
        return toRead;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }

    public ContentDescriptor getContentDescriptor() {
        return RAW_CONTENT_DISCRIPTOR;
    }

    public boolean endOfStream() {
        return this.location == (long)this.data.length;
    }

    public long getContentLength() {
        return this.data.length;
    }

    public boolean willReadBlock() {
        return this.endOfStream();
    }

    public boolean isRandomAccess() {
        return true;
    }

    public long seek(long where) {
        this.location = where > (long)this.data.length ? (long)this.data.length : where;
        return this.location;
    }

    public long tell() {
        return this.location;
    }
}

