/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lang;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtilities {
    private static HashMap<String, Class<?>> s_primativeTypeMap = new HashMap();

    public static <E> E getInstance(Object o, Class<E> cls) {
        Object rv = null;
        if (o != null && cls.isAssignableFrom(o.getClass())) {
            rv = o;
        }
        return (E)rv;
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        assert (className != null);
        assert (className.length() > 0);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (s_primativeTypeMap.containsKey(className)) {
                return s_primativeTypeMap.get(className);
            }
            throw cnfe;
        }
    }

    public static boolean isAssignableToAtLeastOne(Class<?> right, Class<?> ... lefts) {
        for (Class<?> left : lefts) {
            if (!left.isAssignableFrom(right)) continue;
            return true;
        }
        return false;
    }

    public static int getArrayDimensionCount(String packageNameAndSimpleClassNames) {
        char c;
        int i;
        int N = packageNameAndSimpleClassNames.length();
        for (i = 0; i < N && (c = packageNameAndSimpleClassNames.charAt(i)) == '['; ++i) {
        }
        return i;
    }

    public static String getPackageName(String packageNameAndSimpleClassNames) {
        int index = packageNameAndSimpleClassNames.lastIndexOf(46);
        if (index != -1) {
            int beginIndex = ClassUtilities.getArrayDimensionCount(packageNameAndSimpleClassNames);
            if (beginIndex > 0) {
                assert (packageNameAndSimpleClassNames.charAt(beginIndex) == 'L');
                ++beginIndex;
            }
            return packageNameAndSimpleClassNames.substring(beginIndex, index);
        }
        return null;
    }

    public static String[] getSimpleClassNames(String packageNameAndSimpleClassNames) {
        int index = packageNameAndSimpleClassNames.lastIndexOf(46);
        int n = packageNameAndSimpleClassNames.length();
        if (packageNameAndSimpleClassNames.charAt(n - 1) == ';') {
            --n;
        }
        String simpleClassNames = packageNameAndSimpleClassNames.substring(index + 1, n);
        return simpleClassNames.split("\\$");
    }

    public static String getTrimmedClassName(Class<?> cls) {
        if (cls != null) {
            if (cls.isMemberClass()) {
                Package pckg = cls.getPackage();
                return cls.getName().substring(pckg.getName().length() + 1);
            }
            return cls.getSimpleName();
        }
        return null;
    }

    static {
        s_primativeTypeMap.put(Void.TYPE.getName(), Void.TYPE);
        s_primativeTypeMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        s_primativeTypeMap.put(Byte.TYPE.getName(), Byte.TYPE);
        s_primativeTypeMap.put(Character.TYPE.getName(), Character.TYPE);
        s_primativeTypeMap.put(Short.TYPE.getName(), Short.TYPE);
        s_primativeTypeMap.put(Integer.TYPE.getName(), Integer.TYPE);
        s_primativeTypeMap.put(Long.TYPE.getName(), Long.TYPE);
        s_primativeTypeMap.put(Double.TYPE.getName(), Double.TYPE);
        s_primativeTypeMap.put(Float.TYPE.getName(), Float.TYPE);
    }
}

