/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass;

import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Visual;

public class PickResult {
    private Component m_sgSource;
    private Visual m_sgVisual;
    private boolean m_isFrontFacing;
    private Geometry m_sgGeometry;
    private int m_subElement;
    private Point3 m_xyzInSource = new Point3();
    private Point3 m_xyzInVisual = new Point3();

    public PickResult() {
        this.setNaN();
    }

    public PickResult(Component sgSource) {
        this.set(sgSource);
    }

    public PickResult(Component sgSource, Visual sgVisual, boolean isFrontFacing, Geometry sgGeometry, int subElement, Point3 xyzInSource) {
        this.set(sgSource, sgVisual, isFrontFacing, sgGeometry, subElement, xyzInSource);
    }

    public void set(Component sgSource) {
        this.setNaN();
        this.m_sgSource = sgSource;
    }

    public void set(Component sgSource, Visual sgVisual, boolean isFrontFacing, Geometry sgGeometry, int subElement, Point3 xyzInSource) {
        this.m_sgSource = sgSource;
        this.m_sgVisual = sgVisual;
        this.m_isFrontFacing = isFrontFacing;
        this.m_sgGeometry = sgGeometry;
        this.m_subElement = subElement;
        if (xyzInSource != null) {
            this.m_xyzInSource.set(xyzInSource);
        } else {
            this.m_xyzInSource.setNaN();
        }
        this.m_xyzInVisual.setNaN();
    }

    public void setNaN() {
        this.set(null, null, false, null, -1, null);
    }

    public Component getSource() {
        return this.m_sgSource;
    }

    public Visual getVisual() {
        return this.m_sgVisual;
    }

    public Geometry getGeometry() {
        return this.m_sgGeometry;
    }

    public boolean isFrontFacing() {
        return this.m_isFrontFacing;
    }

    public int getSubElement() {
        return this.m_subElement;
    }

    public Point3 accessPositionInSource() {
        return this.m_xyzInSource;
    }

    public Point3 getPositionInSource(Point3 rv) {
        rv.set(this.accessPositionInSource());
        return rv;
    }

    public Point3 getPositionInSource() {
        return this.getPositionInSource(new Point3());
    }

    public Point3 accessPositionInVisual() {
        if (this.m_xyzInSource.isNaN() && !this.m_xyzInVisual.isNaN()) {
            assert (this.m_sgVisual != null);
            this.m_sgVisual.transformFrom_AffectReturnValuePassedIn(this.m_xyzInVisual, this.m_sgSource);
        }
        return this.m_xyzInVisual;
    }

    public Point3 getPositionInVisual(Point3 rv) {
        rv.set(this.accessPositionInVisual());
        return rv;
    }

    public Point3 getPositionInVisual() {
        return this.getPositionInVisual(new Point3());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[visual=");
        sb.append(this.m_sgVisual);
        sb.append("]");
        return sb.toString();
    }
}

