/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.Graphics2D;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.BackgroundAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.ConformanceTestResults;
import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.lookingglass.opengl.GhostAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.LayerAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.LeafAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickParameters;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.SceneAdapter;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.pattern.AbstractElement;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCameraAdapter<E extends AbstractCamera>
extends LeafAdapter<E> {
    private BackgroundAdapter m_backgroundAdapter = null;
    private LayerAdapter[] m_layerAdapters = null;
    private Rectangle m_specifiedViewport = null;
    private boolean m_isLetterboxedAsOpposedToDistorted = true;

    public abstract Ray getRayAtPixel(Ray var1, int var2, int var3, Rectangle var4);

    protected abstract Rectangle performLetterboxing(Rectangle var1);

    public Rectangle getActualViewport(Rectangle rv, int width, int height) {
        if (this.m_specifiedViewport != null) {
            rv.setBounds(this.m_specifiedViewport);
        } else {
            rv.setBounds(0, 0, width, height);
        }
        if (this.m_isLetterboxedAsOpposedToDistorted) {
            this.performLetterboxing(rv);
        }
        return rv;
    }

    public abstract Matrix4x4 getActualProjectionMatrix(Matrix4x4 var1, Rectangle var2);

    public Rectangle getSpecifiedViewport() {
        if (this.m_specifiedViewport != null) {
            return new Rectangle(this.m_specifiedViewport);
        }
        return null;
    }

    public void setSpecifiedViewport(Rectangle specifiedViewport) {
        this.m_specifiedViewport = specifiedViewport != null ? new Rectangle(specifiedViewport) : null;
    }

    public boolean isLetterboxedAsOpposedToDistorted() {
        return this.m_isLetterboxedAsOpposedToDistorted;
    }

    public void setIsLetterboxedAsOpposedToDistorted(boolean isLetterboxedAsOpposedToDistorted) {
        this.m_isLetterboxedAsOpposedToDistorted = isLetterboxedAsOpposedToDistorted;
    }

    @Override
    public void setup(RenderContext rc) {
    }

    protected abstract void setupProjection(Context var1, Rectangle var2);

    public void performClearAndRenderOffscreen(RenderContext rc, int width, int height) {
        SceneAdapter sceneAdapter = this.getSceneAdapter();
        if (sceneAdapter != null) {
            Rectangle actualViewport = this.getActualViewport(new Rectangle(), width, height);
            rc.gl.glMatrixMode(5889);
            rc.gl.glLoadIdentity();
            this.setupProjection(rc, actualViewport);
            rc.setViewportAndAddToClearRect(actualViewport);
            sceneAdapter.renderScene(rc, this, this.m_backgroundAdapter);
        }
    }

    public void postRender(RenderContext rc, int width, int height, LookingGlass lookingGlass, Graphics2D g2) {
        if (this.m_layerAdapters != null) {
            Rectangle actualViewport = this.getActualViewport(new Rectangle(), width, height);
            for (LayerAdapter layerAdapter : this.m_layerAdapters) {
                layerAdapter.render(g2, lookingGlass, actualViewport, (AbstractCamera)this.m_element);
            }
        }
    }

    public void performPick(PickContext pc, PickParameters pickParameters, Rectangle actualViewport, ConformanceTestResults conformanceTestResults) {
        SceneAdapter sceneAdapter = this.getSceneAdapter();
        if (sceneAdapter != null) {
            pc.gl.glViewport(actualViewport.x, actualViewport.y, actualViewport.width, actualViewport.height);
            pc.gl.glMatrixMode(5889);
            pc.gl.glLoadIdentity();
            double tx = actualViewport.width - 2 * (pickParameters.getX() - actualViewport.x);
            double ty = actualViewport.height - 2 * (pickParameters.getFlippedY(actualViewport) - actualViewport.y);
            pc.gl.glTranslated(tx, ty, 0.0);
            pc.gl.glScaled((double)actualViewport.width, (double)actualViewport.height, 1.0);
            this.setupProjection(pc, actualViewport);
            pc.pickScene(this, sceneAdapter, pickParameters, conformanceTestResults);
        }
    }

    @Override
    public void renderGhost(RenderContext rc, GhostAdapter root) {
    }

    @Override
    public void renderOpaque(RenderContext rc) {
    }

    @Override
    public void pick(PickContext pc, PickParameters pickParameters, ConformanceTestResults conformanceTestResults) {
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((AbstractCamera)this.m_element).background) {
            this.m_backgroundAdapter = AdapterFactory.getAdapterFor(((AbstractCamera)this.m_element).background.getValue());
        } else if (property == ((AbstractCamera)this.m_element).postRenderLayers) {
            this.m_layerAdapters = (LayerAdapter[])AdapterFactory.getAdaptersFor((AbstractElement[])((AbstractElement[])((AbstractCamera)this.m_element).postRenderLayers.getValue()), LayerAdapter.class);
        } else {
            super.propertyChanged(property);
        }
    }
}

