/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.timing.Timer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;

public class ConformanceTestResults {
    private static final long FISHY_PICK_VALUE = 0x80000000L;
    private String version;
    private String vendor;
    private String renderer;
    private String[] extensions;
    private boolean isPickFunctioningCorrectly;
    private boolean isValid;

    private static long convertZValueToLong(int zValue) {
        long rv = zValue;
        return rv &= 0xFFFFFFFFL;
    }

    private static float convertZValueToFloat(long zValue) {
        float zFront = zValue;
        return zFront /= 4.2949673E9f;
    }

    private ConformanceTestResults() {
        GLDrawableFactory factory = GLDrawableFactory.getFactory();
        if (factory.canCreateGLPbuffer()) {
            GLCapabilities glDesiredCapabilities = new GLCapabilities();
            GLPbuffer glPbuffer = factory.createGLPbuffer(glDesiredCapabilities, (GLCapabilitiesChooser)new DefaultGLCapabilitiesChooser(), 1, 1, null);
            GLContext glContext = glPbuffer.getContext();
            glContext.makeCurrent();
            GL gl = glPbuffer.getGL();
            this.inititialize(gl);
        }
    }

    public ConformanceTestResults(GL gl) {
        this.inititialize(gl);
    }

    private void inititialize(GL gl) {
        Timer timer = new Timer();
        timer.start();
        timer.mark(gl);
        this.version = gl.glGetString(7938);
        this.vendor = gl.glGetString(7936);
        this.renderer = gl.glGetString(7937);
        String extensionsText = gl.glGetString(7939);
        this.extensions = extensionsText.split(" ");
        int SELECTION_CAPACITY = 256;
        int SIZEOF_INT = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer selectionAsIntBuffer = byteBuffer.asIntBuffer();
        float XY = 2.0f;
        float Z = 0.5f;
        int KEY = 11235;
        gl.glSelectBuffer(256, selectionAsIntBuffer);
        gl.glRenderMode(7170);
        gl.glClearDepth(1.0);
        gl.glDepthFunc(515);
        gl.glEnable(2929);
        gl.glDisable(2884);
        gl.glClear(256);
        gl.glInitNames();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        gl.glViewport(0, 0, 1, 1);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glPushName(11235);
        gl.glBegin(8);
        gl.glVertex3f(-2.0f, -2.0f, 0.5f);
        gl.glVertex3f(2.0f, -2.0f, 0.5f);
        gl.glVertex3f(2.0f, 2.0f, 0.5f);
        gl.glVertex3f(-2.0f, 2.0f, 0.5f);
        gl.glEnd();
        gl.glFlush();
        gl.glPopName();
        timer.mark("picked");
        selectionAsIntBuffer.rewind();
        int length = gl.glRenderMode(7168);
        if (length == 1) {
            int nameCount = selectionAsIntBuffer.get(0);
            int zFrontAsInt = selectionAsIntBuffer.get(1);
            long zFrontAsLong = ConformanceTestResults.convertZValueToLong(zFrontAsInt);
            if (zFrontAsLong != 0x80000000L && zFrontAsLong != 0xFFFFFFFFL && zFrontAsLong != 0L) {
                int key;
                boolean IS_BACK_VALUE_OF_CONCERN = false;
                if (IS_BACK_VALUE_OF_CONCERN) {
                    int zBackAsInt = selectionAsIntBuffer.get(2);
                    long zBackAsLong = ConformanceTestResults.convertZValueToLong(zBackAsInt);
                    float zBack = ConformanceTestResults.convertZValueToFloat(zBackAsLong);
                }
                if (nameCount == 1 && (key = selectionAsIntBuffer.get(3)) == 11235) {
                    this.isPickFunctioningCorrectly = true;
                }
            }
        }
        timer.mark("processed");
        this.isValid = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isPickFunctioningCorrectly() {
        return this.isPickFunctioningCorrectly;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public static void main(String[] args) {
        ConformanceTestResults conformanceTestResults = new ConformanceTestResults();
        PrintUtilities.println("isValid:", conformanceTestResults.isValid());
        PrintUtilities.println("isPickFunctioningCorrectly:", conformanceTestResults.isPickFunctioningCorrectly());
        PrintUtilities.println("version:", conformanceTestResults.getVersion());
        PrintUtilities.println("vendor:", conformanceTestResults.getVendor());
        PrintUtilities.println("renderer:", conformanceTestResults.getRenderer());
        PrintUtilities.println("extensions:", conformanceTestResults.getExtensions());
        System.exit(0);
    }
}

