/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.lookingglass.opengl.GeometryAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.ShapeAdapter;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.Cylinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CylinderAdapter
extends ShapeAdapter<Cylinder> {
    private double m_length;
    private double m_bottomRadius;
    private double m_topRadius;
    private boolean m_hasBottomCap;
    private boolean m_hasTopCap;
    private Cylinder.OriginAlignment m_originAlignment;
    private Cylinder.BottomToTopAxis m_bottomToTopAxis;
    private int m_slices = 50;
    private int m_stacks = 1;
    private int m_loops = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void glCylinder(Context c) {
        double topRadius = Double.isNaN(this.m_topRadius) ? this.m_bottomRadius : this.m_topRadius;
        c.gl.glPushMatrix();
        try {
            double z;
            if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.POSITIVE_X) {
                c.gl.glRotated(90.0, 0.0, 1.0, 0.0);
            } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.POSITIVE_Y) {
                c.gl.glRotated(-90.0, 1.0, 0.0, 0.0);
            } else if (this.m_bottomToTopAxis != Cylinder.BottomToTopAxis.POSITIVE_Z) {
                if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.NEGATIVE_X) {
                    c.gl.glRotated(-90.0, 0.0, 1.0, 0.0);
                } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.NEGATIVE_Y) {
                    c.gl.glRotated(90.0, 1.0, 0.0, 0.0);
                } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.NEGATIVE_Z) {
                    c.gl.glRotated(180.0, 1.0, 0.0, 0.0);
                } else {
                    throw new RuntimeException();
                }
            }
            if (this.m_originAlignment == Cylinder.OriginAlignment.BOTTOM) {
                z = 0.0;
            } else if (this.m_originAlignment == Cylinder.OriginAlignment.CENTER) {
                z = -this.m_length * 0.5;
            } else if (this.m_originAlignment == Cylinder.OriginAlignment.TOP) {
                z = -this.m_length;
            } else {
                throw new RuntimeException();
            }
            c.gl.glTranslated(0.0, 0.0, z);
            c.glu.gluCylinder(c.getQuadric(), this.m_bottomRadius, topRadius, this.m_length, this.m_slices, this.m_stacks);
            if (this.m_hasBottomCap && this.m_bottomRadius > 0.0) {
                c.gl.glRotated(180.0, 1.0, 0.0, 0.0);
                c.glu.gluDisk(c.getQuadric(), 0.0, this.m_bottomRadius, this.m_slices, this.m_stacks);
                c.gl.glRotated(180.0, 1.0, 0.0, 0.0);
            }
            if (this.m_hasTopCap && topRadius > 0.0) {
                c.gl.glTranslated(0.0, 0.0, this.m_length);
                c.glu.gluDisk(c.getQuadric(), 0.0, topRadius, this.m_slices, this.m_loops);
                c.gl.glTranslated(0.0, 0.0, -this.m_length);
            }
        }
        finally {
            c.gl.glPopMatrix();
        }
    }

    @Override
    protected void renderGeometry(RenderContext rc) {
        this.glCylinder(rc);
    }

    @Override
    protected void pickGeometry(PickContext pc, boolean isSubElementRequired) {
        int name = isSubElementRequired ? 0 : -1;
        pc.gl.glPushName(name);
        this.glCylinder(pc);
        pc.gl.glPopName();
    }

    @Override
    public Point3 getIntersectionInSource(Point3 rv, Ray ray, AffineMatrix4x4 m, int subElement) {
        double topValue;
        double bottomValue;
        if (this.m_originAlignment == Cylinder.OriginAlignment.BOTTOM) {
            bottomValue = 0.0;
            topValue = this.m_length;
        } else if (this.m_originAlignment == Cylinder.OriginAlignment.CENTER) {
            bottomValue = -this.m_length * 0.5;
            topValue = this.m_length * 0.5;
        } else if (this.m_originAlignment == Cylinder.OriginAlignment.TOP) {
            bottomValue = this.m_length;
            topValue = 0.0;
        } else {
            throw new RuntimeException();
        }
        Point3 cylinderPosition = new Point3(0.0, 0.0, 0.0);
        Vector3 cylinderDirection = new Vector3(0.0, 0.0, 0.0);
        Point3 cylinderTopPosition = new Point3(0.0, 0.0, 0.0);
        if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.POSITIVE_X) {
            cylinderDirection.x = 1.0;
            cylinderPosition.x = bottomValue;
            cylinderTopPosition.x = topValue;
        } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.POSITIVE_Y) {
            cylinderDirection.y = 1.0;
            cylinderPosition.y = bottomValue;
            cylinderTopPosition.y = topValue;
        } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.POSITIVE_Z) {
            cylinderDirection.z = 1.0;
            cylinderPosition.z = bottomValue;
            cylinderTopPosition.z = topValue;
        } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.NEGATIVE_X) {
            cylinderDirection.x = -1.0;
            cylinderPosition.x = -bottomValue;
            cylinderTopPosition.x = -topValue;
        } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.NEGATIVE_Y) {
            cylinderDirection.y = -1.0;
            cylinderPosition.y = -bottomValue;
            cylinderTopPosition.y = -topValue;
        } else if (this.m_bottomToTopAxis == Cylinder.BottomToTopAxis.NEGATIVE_Z) {
            cylinderDirection.z = -1.0;
            cylinderPosition.z = -bottomValue;
            cylinderTopPosition.z = -topValue;
        } else {
            throw new RuntimeException();
        }
        double maxRadius = Math.max(this.m_bottomRadius, this.m_topRadius);
        m.transform(cylinderPosition);
        m.transform(cylinderDirection);
        boolean HANDLE_CONES_SEPARATELY = false;
        double t = Double.NaN;
        double THRESHOLD = 0.01;
        if (Double.isNaN(t)) {
            rv.setNaN();
        } else {
            ray.getPointAlong(rv, t);
        }
        if (rv.isNaN()) {
            Point3 pTopCap;
            Point3 pBottomCap;
            if (this.m_hasBottomCap && this.m_bottomRadius > 0.0) {
                pBottomCap = new Point3();
                GeometryAdapter.getIntersectionInSourceFromPlaneInLocal(pBottomCap, ray, m, cylinderPosition, cylinderDirection);
            } else {
                pBottomCap = null;
            }
            if (this.m_hasTopCap && this.m_topRadius > 0.0) {
                pTopCap = new Point3();
                GeometryAdapter.getIntersectionInSourceFromPlaneInLocal(pTopCap, ray, m, cylinderTopPosition, cylinderDirection);
            } else {
                pTopCap = null;
            }
            if (pBottomCap != null && (rv.isNaN() || rv.z > pBottomCap.z)) {
                rv.set(pBottomCap);
            }
            if (pTopCap != null && (rv.isNaN() || rv.z > pTopCap.z)) {
                rv.set(pTopCap);
            }
        }
        return rv;
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Cylinder)this.m_element).length) {
            this.m_length = (Double)((Cylinder)this.m_element).length.getValue();
            this.setIsGeometryChanged(true);
        } else if (property == ((Cylinder)this.m_element).bottomRadius) {
            this.m_bottomRadius = (Double)((Cylinder)this.m_element).bottomRadius.getValue();
            this.setIsGeometryChanged(true);
        } else if (property == ((Cylinder)this.m_element).topRadius) {
            this.m_topRadius = (Double)((Cylinder)this.m_element).topRadius.getValue();
            this.setIsGeometryChanged(true);
        } else if (property == ((Cylinder)this.m_element).hasBottomCap) {
            this.m_hasBottomCap = (Boolean)((Cylinder)this.m_element).hasBottomCap.getValue();
            this.setIsGeometryChanged(true);
        } else if (property == ((Cylinder)this.m_element).hasTopCap) {
            this.m_hasTopCap = (Boolean)((Cylinder)this.m_element).hasTopCap.getValue();
            this.setIsGeometryChanged(true);
        } else if (property == ((Cylinder)this.m_element).originAlignment) {
            this.m_originAlignment = ((Cylinder)this.m_element).originAlignment.getValue();
            this.setIsGeometryChanged(true);
        } else if (property == ((Cylinder)this.m_element).bottomToTopAxis) {
            this.m_bottomToTopAxis = ((Cylinder)this.m_element).bottomToTopAxis.getValue();
            this.setIsGeometryChanged(true);
        } else {
            super.propertyChanged(property);
        }
    }
}

