/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractPerspectiveCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.math.ClippedZPlane;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.FrustumPerspectiveCamera;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrustumPerspectiveCameraAdapter
extends AbstractPerspectiveCameraAdapter<FrustumPerspectiveCamera> {
    private static ClippedZPlane s_actualPicturePlaneBufferForReuse = new ClippedZPlane(Double.NaN, Double.NaN, Double.NaN, Double.NaN);

    @Override
    public Ray getRayAtPixel(Ray rv, int xPixel, int yPixel, Rectangle actualViewport) {
        throw new RuntimeException("TODO");
    }

    @Override
    public Matrix4x4 getActualProjectionMatrix(Matrix4x4 rv, Rectangle actualViewport) {
        ClippedZPlane actualPicturePlane = this.getActualPicturePlane(new ClippedZPlane(), actualViewport);
        double left = actualPicturePlane.getXMinimum();
        double right = actualPicturePlane.getXMaximum();
        double bottom = actualPicturePlane.getYMinimum();
        double top = actualPicturePlane.getYMaximum();
        double zNear = (Double)((FrustumPerspectiveCamera)this.m_element).nearClippingPlaneDistance.getValue();
        double zFar = (Double)((FrustumPerspectiveCamera)this.m_element).farClippingPlaneDistance.getValue();
        rv.right.set(2.0 * zNear, 0.0, 0.0, 0.0);
        rv.up.set(0.0, 2.0 * zNear / (top - bottom), 0.0, 0.0);
        rv.backward.set((right + left) / (right - left), (top + bottom) / (top - bottom), -(zFar + zNear) / (zFar + zNear), -1.0);
        rv.translation.set(0.0, 0.0, -(2.0 * zFar * zNear) / (zFar - zNear), 0.0);
        throw new RuntimeException("todo");
    }

    @Override
    protected Rectangle performLetterboxing(Rectangle rv) {
        return rv;
    }

    protected ClippedZPlane getActualPicturePlane(ClippedZPlane rv, Rectangle actualViewport) {
        rv.set((ClippedZPlane)((FrustumPerspectiveCamera)this.m_element).picturePlane.getValue(), actualViewport);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupProjection(Context context, Rectangle actualViewport, float near, float far) {
        ClippedZPlane clippedZPlane = s_actualPicturePlaneBufferForReuse;
        synchronized (clippedZPlane) {
            this.getActualPicturePlane(s_actualPicturePlaneBufferForReuse, actualViewport);
            context.gl.glFrustum(s_actualPicturePlaneBufferForReuse.getXMinimum(), s_actualPicturePlaneBufferForReuse.getXMaximum(), s_actualPicturePlaneBufferForReuse.getYMinimum(), s_actualPicturePlaneBufferForReuse.getYMaximum(), (double)near, (double)far);
        }
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property != ((FrustumPerspectiveCamera)this.m_element).picturePlane) {
            super.propertyChanged(property);
        }
    }
}

