/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.PickObserver;
import edu.cmu.cs.dennisc.lookingglass.PickResult;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassDisplayChangeEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassInitializeEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassRenderEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassResizeEvent;
import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.ChangeHandler;
import edu.cmu.cs.dennisc.lookingglass.opengl.ConformanceTestResults;
import edu.cmu.cs.dennisc.lookingglass.opengl.Graphics2D;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickParameters;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.SelectionBufferInfo;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.ScaleUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GLEventAdapter
implements GLEventListener {
    private AbstractLookingGlass lookingGlass;
    private GLAutoDrawable drawable;
    private RenderContext renderContext = new RenderContext();
    private PickContext pickContext = new PickContext();
    private int width;
    private int height;
    private PickParameters pickParameters = null;
    private BufferedImage rvColorBuffer = null;
    private FloatBuffer rvDepthBuffer = null;
    private static final int SELECTION_CAPACITY = 256;
    private IntBuffer selectionAsIntBuffer = null;
    private boolean isDisplayIgnoredDueToPreviousException = false;
    private ReusableLookingGlassRenderEvent reusableLookingGlassRenderEvent;
    private boolean isListening;
    private static ConformanceTestResults conformanceTestResults = null;

    public GLEventAdapter(AbstractLookingGlass lookingGlass) {
        this.lookingGlass = lookingGlass;
        this.reusableLookingGlassRenderEvent = new ReusableLookingGlassRenderEvent(this.lookingGlass, new Graphics2D(this.renderContext));
        int SIZEOF_INT = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.selectionAsIntBuffer = byteBuffer.asIntBuffer();
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void startListening(GLAutoDrawable drawable) {
        if (this.isListening) {
            assert (drawable == this.drawable);
            System.err.println("request GLEventAdapter.startListening( drawable ) ignored; already listening.");
        } else {
            this.isListening = true;
            this.drawable = drawable;
            this.drawable.addGLEventListener((GLEventListener)this);
        }
    }

    public void stopListening(GLAutoDrawable drawable) {
        assert (drawable == this.drawable);
        if (this.isListening) {
            this.isListening = false;
            drawable.removeGLEventListener((GLEventListener)this);
        } else {
            System.err.println("request GLEventAdapter.stopListening( drawable ) ignored; already not listening.");
        }
        this.drawable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRender() {
        if (this.lookingGlass.isRenderingEnabled()) {
            this.renderContext.actuallyForgetTexturesIfNecessary();
            this.renderContext.actuallyForgetDisplayListsIfNecessary();
            if (!this.isDisplayIgnoredDueToPreviousException) {
                try {
                    this.reusableLookingGlassRenderEvent.prologue();
                    try {
                        this.lookingGlass.fireCleared(this.reusableLookingGlassRenderEvent);
                    }
                    finally {
                        this.reusableLookingGlassRenderEvent.epilogue();
                    }
                    if (this.lookingGlass.getCameraCount() > 0) {
                        Iterable<AbstractCamera> cameras;
                        this.renderContext.initialize();
                        Iterable<AbstractCamera> iterable = cameras = this.lookingGlass.accessCameras();
                        synchronized (iterable) {
                            for (AbstractCamera camera : cameras) {
                                AbstractCameraAdapter<? extends AbstractCamera> cameraAdapterI = AdapterFactory.getAdapterFor(camera);
                                cameraAdapterI.performClearAndRenderOffscreen(this.renderContext, this.width, this.height);
                                this.reusableLookingGlassRenderEvent.prologue();
                                try {
                                    cameraAdapterI.postRender(this.renderContext, this.width, this.height, this.lookingGlass, this.reusableLookingGlassRenderEvent.getGraphics2D());
                                }
                                finally {
                                    this.reusableLookingGlassRenderEvent.epilogue();
                                }
                            }
                        }
                        this.renderContext.renderLetterboxingIfNecessary(this.width, this.height);
                    } else {
                        this.renderContext.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                        this.renderContext.gl.glClear(16384);
                    }
                    this.reusableLookingGlassRenderEvent.prologue();
                    try {
                        this.lookingGlass.fireRendered(this.reusableLookingGlassRenderEvent);
                    }
                    finally {
                        this.reusableLookingGlassRenderEvent.epilogue();
                    }
                    if (this.rvColorBuffer != null || this.rvDepthBuffer != null) {
                        this.renderContext.captureBuffers(this.rvColorBuffer, this.rvDepthBuffer);
                    }
                }
                catch (RuntimeException re) {
                    System.err.println("rendering will be disabled due to exception");
                    this.isDisplayIgnoredDueToPreviousException = true;
                    throw re;
                }
            }
        }
    }

    private void performPick() {
        PickObserver pickObserver;
        if (conformanceTestResults == null && !(conformanceTestResults = new ConformanceTestResults(this.pickContext.gl)).isPickFunctioningCorrectly()) {
            PrintUtilities.println("opengl isPickFunctioningCorrectly:", conformanceTestResults.isPickFunctioningCorrectly());
            PrintUtilities.println("opengl version:", conformanceTestResults.getVersion());
            PrintUtilities.println("opengl vendor:", conformanceTestResults.getVendor());
            PrintUtilities.println("opengl renderer:", conformanceTestResults.getRenderer());
            PrintUtilities.println("opengl extensions:", conformanceTestResults.getExtensions());
        }
        if ((pickObserver = this.pickParameters.getPickObserver()) != null) {
            pickObserver.prePick();
            ChangeHandler.handleBufferedChanges();
        }
        AbstractCamera sgCamera = this.pickParameters.getSGCamera();
        AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter = AdapterFactory.getAdapterFor(sgCamera);
        this.selectionAsIntBuffer.rewind();
        this.pickContext.gl.glSelectBuffer(256, this.selectionAsIntBuffer);
        this.pickContext.gl.glRenderMode(7170);
        this.pickContext.gl.glInitNames();
        Rectangle actualViewport = this.lookingGlass.getActualViewport(sgCamera);
        this.pickContext.gl.glViewport(actualViewport.x, actualViewport.y, actualViewport.width, actualViewport.height);
        cameraAdapter.performPick(this.pickContext, this.pickParameters, actualViewport, conformanceTestResults);
        this.pickContext.gl.glFlush();
        this.selectionAsIntBuffer.rewind();
        int length = this.pickContext.gl.glRenderMode(7168);
        if (length > 0) {
            SelectionBufferInfo[] selectionBufferInfos = new SelectionBufferInfo[length];
            int offset = 0;
            for (int i = 0; i < length; ++i) {
                selectionBufferInfos[i] = new SelectionBufferInfo(this.pickContext, this.selectionAsIntBuffer, offset);
                offset += 7;
            }
            if (conformanceTestResults.isPickFunctioningCorrectly()) {
                double x = this.pickParameters.getX();
                double y = this.pickParameters.getFlippedY(actualViewport);
                Matrix4x4 m = new Matrix4x4();
                m.translation.set((double)actualViewport.width - 2.0 * (x - (double)actualViewport.x), (double)actualViewport.height - 2.0 * (y - (double)actualViewport.y), 0.0, 1.0);
                ScaleUtilities.applyScale(m, (double)actualViewport.width, (double)actualViewport.height, 1.0);
                Matrix4x4 p = new Matrix4x4();
                cameraAdapter.getActualProjectionMatrix(p, actualViewport);
                m.applyMultiplication(p);
                m.invert();
                for (SelectionBufferInfo selectionBufferInfo : selectionBufferInfos) {
                    selectionBufferInfo.updatePointInSource(m);
                }
            } else {
                Ray ray = new Ray();
                ray.setNaN();
                cameraAdapter.getRayAtPixel(ray, this.pickParameters.getX(), this.pickParameters.getY(), actualViewport);
                ray.accessDirection().normalize();
                AffineMatrix4x4 inverseAbsoluteTransformation = sgCamera.getInverseAbsoluteTransformation();
                for (SelectionBufferInfo selectionBufferInfo : selectionBufferInfos) {
                    selectionBufferInfo.updatePointInSource(ray, inverseAbsoluteTransformation);
                }
            }
            if (length > 1) {
                Comparator<SelectionBufferInfo> comparator = conformanceTestResults.isPickFunctioningCorrectly() ? new Comparator<SelectionBufferInfo>(){

                    @Override
                    public int compare(SelectionBufferInfo sbi1, SelectionBufferInfo sbi2) {
                        return Float.compare(sbi1.getZFront(), sbi2.getZFront());
                    }
                } : new Comparator<SelectionBufferInfo>(){

                    @Override
                    public int compare(SelectionBufferInfo sbi1, SelectionBufferInfo sbi2) {
                        double z1 = -sbi1.getPointInSource().z;
                        double z2 = -sbi2.getPointInSource().z;
                        return Double.compare(z1, z2);
                    }
                };
                Arrays.sort(selectionBufferInfos, comparator);
            }
            for (SelectionBufferInfo selectionBufferInfo : selectionBufferInfos) {
                this.pickParameters.addPickResult(sgCamera, selectionBufferInfo.getSGVisual(), selectionBufferInfo.isFrontFacing(), selectionBufferInfo.getSGGeometry(), selectionBufferInfo.getSubElement(), selectionBufferInfo.getPointInSource());
            }
        }
        if (pickObserver != null) {
            pickObserver.postPick();
            ChangeHandler.handleBufferedChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PickResult pickFrontMost(AbstractCamera sgCamera, int xPixel, int yPixel, boolean isSubElementRequired, PickObserver pickObserver) {
        assert (sgCamera != null);
        assert (this.drawable != null);
        this.drawable.setAutoSwapBufferMode(false);
        try {
            this.pickParameters = new PickParameters(this.drawable, sgCamera, xPixel, yPixel, isSubElementRequired, pickObserver);
            this.drawable.display();
            PickResult pickResult = this.pickParameters.accessFrontMostPickResult();
            return pickResult;
        }
        finally {
            this.drawable.setAutoSwapBufferMode(true);
            this.pickParameters = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PickResult> pickAll(AbstractCamera sgCamera, int xPixel, int yPixel, boolean isSubElementRequired, PickObserver pickObserver) {
        assert (sgCamera != null);
        this.drawable.setAutoSwapBufferMode(false);
        try {
            this.pickParameters = new PickParameters(this.drawable, sgCamera, xPixel, yPixel, isSubElementRequired, pickObserver);
            this.drawable.display();
            List<PickResult> list = this.pickParameters.accessAllPickResults();
            return list;
        }
        finally {
            this.drawable.setAutoSwapBufferMode(true);
            this.pickParameters = null;
        }
    }

    private BufferedImage createBufferedImageForUseAsColorBuffer(int type) {
        if (this.drawable != null) {
            if (this.width != this.drawable.getWidth() || this.height != this.drawable.getHeight()) {
                PrintUtilities.println("warning: createBufferedImageForUseAsColorBuffer size mismatch");
                this.width = this.drawable.getWidth();
                this.height = this.drawable.getHeight();
            }
        } else {
            PrintUtilities.println("warning: drawable null");
        }
        if (this.width > 0 && this.height > 0) {
            return new BufferedImage(this.width, this.height, type);
        }
        return null;
    }

    public BufferedImage createBufferedImageForUseAsColorBuffer() {
        int type = 6;
        return this.createBufferedImageForUseAsColorBuffer(type);
    }

    public BufferedImage getColorBuffer(BufferedImage rv) {
        return this.getColorBufferWithTransparencyBasedOnDepthBuffer(rv, null);
    }

    public BufferedImage createBufferedImageForUseAsColorBufferWithTransparencyBasedOnDepthBuffer() {
        return this.createBufferedImageForUseAsColorBuffer(6);
    }

    public FloatBuffer createFloatBufferForUseAsDepthBuffer() {
        return FloatBuffer.allocate(this.width * this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatBuffer getDepthBuffer(FloatBuffer rv) {
        this.rvDepthBuffer = rv;
        this.drawable.setAutoSwapBufferMode(false);
        try {
            this.drawable.display();
        }
        finally {
            this.rvDepthBuffer = null;
            this.drawable.setAutoSwapBufferMode(true);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getColorBufferWithTransparencyBasedOnDepthBuffer(BufferedImage rv, FloatBuffer depthBuffer) {
        if (this.drawable.getContext() == GLContext.getCurrent()) {
            this.renderContext.captureBuffers(rv, depthBuffer);
        } else {
            this.rvColorBuffer = rv;
            this.rvDepthBuffer = depthBuffer;
            this.drawable.setAutoSwapBufferMode(false);
            try {
                this.drawable.display();
            }
            finally {
                this.rvColorBuffer = null;
                this.rvDepthBuffer = null;
                this.drawable.setAutoSwapBufferMode(true);
            }
        }
        return rv;
    }

    private void initialize(GLAutoDrawable drawable) {
        assert (drawable == this.drawable);
        GL gl = drawable.getGL();
        boolean USE_DEBUG_GL = false;
        this.renderContext.setGL(gl);
        this.pickContext.setGL(gl);
        this.lookingGlass.fireInitialized(new LookingGlassInitializeEvent(this.lookingGlass, this.drawable.getWidth(), this.drawable.getHeight()));
    }

    public void init(GLAutoDrawable drawable) {
        this.initialize(drawable);
    }

    public void display(GLAutoDrawable drawable) {
        assert (drawable == this.drawable);
        GL gl = drawable.getGL();
        if (this.renderContext.gl == null && this.pickContext.gl == null) {
            this.initialize(drawable);
        }
        if (this.pickParameters != null) {
            this.pickContext.setGL(gl);
            this.performPick();
        } else {
            this.renderContext.setGL(gl);
            this.performRender();
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        assert (drawable == this.drawable);
        this.width = width;
        this.height = height;
        this.lookingGlass.fireResized(new LookingGlassResizeEvent(this.lookingGlass, width, height));
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
        assert (drawable == this.drawable);
        this.lookingGlass.fireDisplayChanged(new LookingGlassDisplayChangeEvent(this.lookingGlass, modeChanged, deviceChanged));
    }

    private class ReusableLookingGlassRenderEvent
    extends LookingGlassRenderEvent {
        public ReusableLookingGlassRenderEvent(LookingGlass lookingGlass, Graphics2D g) {
            super(lookingGlass, g);
        }

        public boolean isReservedForReuse() {
            return true;
        }

        private void prologue() {
            ((Graphics2D)this.getGraphics2D()).initialize(((LookingGlass)this.getTypedSource()).getWidth(), ((LookingGlass)this.getTypedSource()).getHeight());
        }

        private void epilogue() {
            this.getGraphics2D().dispose();
        }
    }
}

