/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import com.sun.opengl.util.j2d.TextRenderer;
import edu.cmu.cs.dennisc.image.ImageGenerator;
import edu.cmu.cs.dennisc.lookingglass.opengl.Pixels;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.math.SineCosineCache;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.texture.BufferedImageTexture;
import edu.cmu.cs.dennisc.texture.CustomTexture;
import edu.cmu.cs.dennisc.texture.Texture;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;

public class Graphics2D
extends edu.cmu.cs.dennisc.lookingglass.Graphics2D {
    private static SineCosineCache s_sineCosineCache = new SineCosineCache(8);
    private static final Paint DEFAULT_PAINT = Color.BLACK;
    private static final Color DEFAULT_BACKGROUND = Color.WHITE;
    private static final Font DEFAULT_FONT = new Font(null, 0, 12);
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private RenderContext m_renderContext;
    private Paint m_paint = DEFAULT_PAINT;
    private Color m_background = DEFAULT_BACKGROUND;
    private Font m_font = DEFAULT_FONT;
    private Stroke m_stroke = DEFAULT_STROKE;
    private RenderingHints m_renderingHints;
    private AffineTransform m_affineTransform = new AffineTransform();
    private double[] m_glTransform = new double[16];
    private DoubleBuffer m_glTransformBuffer = DoubleBuffer.wrap(this.m_glTransform);
    private int m_width = -1;
    private int m_height = -1;
    private static final double FLATNESS = 0.01;
    private static final Stroke LINE_STROKE = new BasicStroke(0.0f);
    private static double[] s_matrix = new double[6];
    private Map<Font, ReferencedObject<TextRenderer>> m_activeFontToTextRendererMap = new HashMap<Font, ReferencedObject<TextRenderer>>();
    private Map<Font, ReferencedObject<TextRenderer>> m_forgottenFontToTextRendererMap = new HashMap<Font, ReferencedObject<TextRenderer>>();
    private Map<Image, ImageGenerator> m_imageToImageGeneratorMap = new HashMap<Image, ImageGenerator>();
    private Map<ImageGenerator, ReferencedObject<Pixels>> m_activeImageGeneratorToPixelsMap = new HashMap<ImageGenerator, ReferencedObject<Pixels>>();
    private Map<ImageGenerator, ReferencedObject<Pixels>> m_forgottenImageGeneratorToPixelsMap = new HashMap<ImageGenerator, ReferencedObject<Pixels>>();

    public Graphics2D(RenderContext renderContext) {
        assert (renderContext != null);
        this.m_renderContext = renderContext;
        HashMap<RenderingHints.Key, Object> map = new HashMap<RenderingHints.Key, Object>();
        map.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        map.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
        map.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DEFAULT);
        map.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        map.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        map.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        map.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        this.m_renderingHints = new RenderingHints(map);
    }

    public void initialize(int width, int height) {
        assert (this.m_renderContext.gl != null);
        assert (this.m_renderContext.glu != null);
        this.m_width = width;
        this.m_height = height;
        this.setPaint(DEFAULT_PAINT);
        this.setBackground(DEFAULT_BACKGROUND);
        this.setFont(DEFAULT_FONT);
        this.m_renderContext.gl.glMatrixMode(5889);
        this.m_renderContext.gl.glPushMatrix();
        this.m_renderContext.gl.glLoadIdentity();
        this.m_renderContext.gl.glOrtho(0.0, (double)(this.m_width - 1), (double)(this.m_height - 1), 0.0, -1.0, 1.0);
        this.m_renderContext.gl.glMatrixMode(5888);
        this.m_renderContext.gl.glPushMatrix();
        this.m_renderContext.gl.glLoadIdentity();
        this.m_affineTransform.setToIdentity();
        this.m_renderContext.gl.glDisable(2929);
        this.m_renderContext.gl.glDisable(2896);
        this.m_renderContext.gl.glDisable(2884);
        this.m_renderContext.setDiffuseColorTextureAdapter(null, false);
        this.m_renderContext.setBumpTextureAdapter(null);
        this.m_renderContext.gl.glPolygonMode(1032, 6914);
    }

    public void dispose() {
        this.m_renderContext.gl.glFlush();
        if (this.isValid()) {
            this.m_renderContext.gl.glMatrixMode(5888);
            this.m_renderContext.gl.glPopMatrix();
            this.m_renderContext.gl.glMatrixMode(5889);
            this.m_renderContext.gl.glPopMatrix();
            this.m_width = -1;
            this.m_height = -1;
        }
    }

    public boolean isValid() {
        return this.m_width != -1 && this.m_height != -1;
    }

    public Graphics create() {
        throw new RuntimeException("not implemented");
    }

    public Color getColor() {
        if (this.m_paint instanceof Color) {
            return (Color)this.m_paint;
        }
        throw new RuntimeException("use getPaint()");
    }

    public void setColor(Color color) {
        this.setPaint(color);
    }

    public void setPaintMode() {
        throw new RuntimeException("not implemented");
    }

    public void setXORMode(Color c1) {
        throw new RuntimeException("not implemented");
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public Rectangle getClipBounds() {
        throw new RuntimeException("not implemented");
    }

    public void clipRect(int x, int y, int width, int height) {
        throw new RuntimeException("not implemented");
    }

    public void setClip(int x, int y, int width, int height) {
        throw new RuntimeException("not implemented");
    }

    public Shape getClip() {
        throw new RuntimeException("not implemented");
    }

    public void setClip(Shape clip) {
        throw new RuntimeException("not implemented");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new RuntimeException("not implemented");
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.m_renderContext.gl.glBegin(1);
        this.m_renderContext.gl.glVertex2i(x1, y1);
        this.m_renderContext.gl.glVertex2i(x2, y2);
        this.m_renderContext.gl.glEnd();
    }

    public void fillRect(int x, int y, int width, int height) {
        this.m_renderContext.gl.glBegin(9);
        this.m_renderContext.gl.glVertex2i(x, y);
        this.m_renderContext.gl.glVertex2i(x + width, y);
        this.m_renderContext.gl.glVertex2i(x + width, y + height);
        this.m_renderContext.gl.glVertex2i(x, y + height);
        this.m_renderContext.gl.glEnd();
    }

    public void clearRect(int x, int y, int width, int height) {
        this.glSetColor(this.m_background);
        this.m_renderContext.gl.glBegin(9);
        this.m_renderContext.gl.glVertex2i(x, y);
        this.m_renderContext.gl.glVertex2i(x + width, y);
        this.m_renderContext.gl.glVertex2i(x + width, y + height);
        this.m_renderContext.gl.glVertex2i(x, y + height);
        this.m_renderContext.gl.glEnd();
        this.glSetPaint(this.m_paint);
    }

    private void glQuarterOval(double centerX, double centerY, double radiusX, double radiusY, int quadrant) {
        int n = Graphics2D.s_sineCosineCache.cosines.length;
        int max = n - 1;
        for (int lcv = 0; lcv < n; ++lcv) {
            int i = max - lcv;
            double cos = s_sineCosineCache.getCosine(quadrant, i);
            double sin = s_sineCosineCache.getSine(quadrant, i);
            this.m_renderContext.gl.glVertex2d(centerX + cos * radiusX, centerY + sin * radiusY);
        }
    }

    private void glRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int x1 = x + arcWidth;
        int x2 = x + width - arcWidth;
        int y1 = y + arcHeight;
        int y2 = y + height - arcHeight;
        this.glQuarterOval(x1, y2, arcWidth, arcHeight, 1);
        this.glQuarterOval(x2, y2, arcWidth, arcHeight, 0);
        this.glQuarterOval(x2, y1, arcWidth, arcHeight, 3);
        this.glQuarterOval(x1, y1, arcWidth, arcHeight, 2);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.m_renderContext.gl.glBegin(2);
        this.glRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.m_renderContext.gl.glEnd();
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.m_renderContext.gl.glBegin(6);
        this.glRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.m_renderContext.gl.glEnd();
    }

    private void glOval(int x, int y, int width, int height) {
        double radiusX = (double)width * 0.5;
        double radiusY = (double)height * 0.5;
        double centerX = (double)x + radiusX;
        double centerY = (double)y + radiusY;
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 3);
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 2);
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 1);
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 0);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.m_renderContext.gl.glBegin(2);
        this.glOval(x, y, width, height);
        this.m_renderContext.gl.glEnd();
    }

    public void fillOval(int x, int y, int width, int height) {
        this.m_renderContext.gl.glBegin(6);
        this.glOval(x, y, width, height);
        this.m_renderContext.gl.glEnd();
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new RuntimeException("not implemented");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new RuntimeException("not implemented");
    }

    private void glPoly(int[] xPoints, int[] yPoints, int nPoints) {
        for (int i = 0; i < nPoints; ++i) {
            this.m_renderContext.gl.glVertex2i(xPoints[i], yPoints[i]);
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_renderContext.gl.glBegin(3);
        this.glPoly(xPoints, yPoints, nPoints);
        this.m_renderContext.gl.glEnd();
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_renderContext.gl.glBegin(2);
        this.glPoly(xPoints, yPoints, nPoints);
        this.m_renderContext.gl.glEnd();
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_renderContext.gl.glBegin(9);
        this.glPoly(xPoints, yPoints, nPoints);
        this.m_renderContext.gl.glEnd();
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new RuntimeException("not implemented");
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        boolean isRemembered = this.isRemembered(image);
        if (!isRemembered) {
            this.remember(image);
        }
        try {
            this.paint(this.m_imageToImageGeneratorMap.get(image), x, y, 1.0f);
        }
        finally {
            if (!isRemembered) {
                this.forget(image);
            }
        }
        return true;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    public boolean drawImage(Image image, int x, int y, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        throw new RuntimeException("not implemented");
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        throw new RuntimeException("not implemented");
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        throw new RuntimeException("not implemented");
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        throw new RuntimeException("not implemented");
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        throw new RuntimeException("not implemented");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        throw new RuntimeException("not implemented");
    }

    public void drawString(String text, float x, float y) {
        ReferencedObject<TextRenderer> referencedObject = this.m_activeFontToTextRendererMap.get(this.m_font);
        if (referencedObject == null) {
            this.remember(this.m_font);
            referencedObject = this.m_activeFontToTextRendererMap.get(this.m_font);
        }
        assert (referencedObject != null);
        TextRenderer glTextRenderer = referencedObject.getObject();
        glTextRenderer.beginRendering(this.m_width, this.m_height);
        if (this.m_paint instanceof Color) {
            Color color = (Color)this.m_paint;
            glTextRenderer.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        }
        int xPixel = (int)((double)x + this.m_affineTransform.getTranslateX());
        int yPixel = (int)((double)y + this.m_affineTransform.getTranslateY());
        glTextRenderer.draw(text, xPixel, this.m_height - yPixel);
        glTextRenderer.endRendering();
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        throw new RuntimeException("todo: use drawString( String, float, float ) for now");
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        int n = g.getNumGlyphs();
        this.translate(x, y);
        for (int i = 0; i < n; ++i) {
            Shape shapeI = g.getGlyphOutline(i);
            this.fill(shapeI);
        }
        this.translate(-x, -y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill(PathIterator pi) {
        class MyTessAdapter
        implements GLUtessellatorCallback {
            private GL m_gl;

            public MyTessAdapter(GL gl) {
                this.m_gl = gl;
            }

            public void begin(int primitiveType) {
                this.m_gl.glBegin(primitiveType);
            }

            public void beginData(int primitiveType, Object data) {
            }

            public void vertex(Object data) {
                double[] a = (double[])data;
                this.m_gl.glVertex2d(a[0], a[1]);
            }

            public void vertexData(Object arg0, Object arg1) {
            }

            public void end() {
                this.m_gl.glEnd();
            }

            public void endData(Object arg0) {
            }

            public void edgeFlag(boolean value) {
            }

            public void edgeFlagData(boolean arg0, Object arg1) {
            }

            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                assert (outData != null);
                assert (outData.length > 0);
                double[] out = new double[]{coords[0], coords[1], coords[2]};
                outData[0] = out;
            }

            public void combineData(double[] arg0, Object[] arg1, float[] arg2, Object[] arg3, Object arg4) {
            }

            public void error(int n) {
            }

            public void errorData(int n, Object data) {
                PrintUtilities.println("tesselator error");
                PrintUtilities.println("\tn:", n);
                try {
                    PrintUtilities.println("\tgluErrorString:", ((Graphics2D)Graphics2D.this).m_renderContext.glu.gluErrorString(n));
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    PrintUtilities.println("\tgluErrorString: unknown");
                }
                PrintUtilities.println("\tdata:", data);
            }
        }
        MyTessAdapter adapter = new MyTessAdapter(this.m_renderContext.gl);
        GLUtessellator tesselator = this.m_renderContext.glu.gluNewTess();
        try {
            this.m_renderContext.glu.gluTessCallback(tesselator, 100100, (GLUtessellatorCallback)adapter);
            this.m_renderContext.glu.gluTessCallback(tesselator, 100101, (GLUtessellatorCallback)adapter);
            this.m_renderContext.glu.gluTessCallback(tesselator, 100102, (GLUtessellatorCallback)adapter);
            this.m_renderContext.glu.gluTessCallback(tesselator, 100104, (GLUtessellatorCallback)adapter);
            this.m_renderContext.glu.gluTessCallback(tesselator, 100105, (GLUtessellatorCallback)adapter);
            this.m_renderContext.glu.gluTessCallback(tesselator, 100103, (GLUtessellatorCallback)adapter);
            double[] segment = new double[6];
            this.m_renderContext.glu.gluBeginPolygon(tesselator);
            try {
                while (!pi.isDone()) {
                    double[] xyz = new double[3];
                    switch (pi.currentSegment(segment)) {
                        case 0: {
                            this.m_renderContext.glu.gluTessBeginContour(tesselator);
                        }
                        case 1: {
                            xyz[0] = segment[0];
                            xyz[1] = segment[1];
                            this.m_renderContext.glu.gluTessVertex(tesselator, xyz, 0, (Object)xyz);
                            break;
                        }
                        case 4: {
                            this.m_renderContext.glu.gluTessEndContour(tesselator);
                            break;
                        }
                        case 2: {
                            throw new RuntimeException("SEG_QUADTO: should not occur when shape.getPathIterator is passed a flatness argument");
                        }
                        case 3: {
                            throw new RuntimeException("SEG_CUBICTO: should not occur when shape.getPathIterator is passed a flatness argument");
                        }
                        default: {
                            throw new RuntimeException("unhandled segment: should not occur");
                        }
                    }
                    pi.next();
                }
            }
            finally {
                this.m_renderContext.glu.gluTessEndPolygon(tesselator);
            }
        }
        finally {
            this.m_renderContext.glu.gluDeleteTess(tesselator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Shape s) {
        Shape outlinesShape;
        boolean isLine;
        if (this.m_stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.m_stroke;
            if (basicStroke.getDashArray() != null) {
                this.m_renderContext.gl.glLineStipple(1, (short)255);
                this.m_renderContext.gl.glEnable(2852);
            }
            isLine = true;
        } else {
            isLine = false;
        }
        if (isLine) {
            outlinesShape = LINE_STROKE.createStrokedShape(s);
            PathIterator pi = outlinesShape.getPathIterator(null, 0.01);
            float[] segment = new float[6];
            this.m_renderContext.gl.glLineWidth(((BasicStroke)this.m_stroke).getLineWidth());
            try {
                while (!pi.isDone()) {
                    switch (pi.currentSegment(segment)) {
                        case 0: {
                            this.m_renderContext.gl.glBegin(3);
                        }
                        case 1: {
                            this.m_renderContext.gl.glVertex2f(segment[0], segment[1]);
                            break;
                        }
                        case 4: {
                            this.m_renderContext.gl.glEnd();
                            break;
                        }
                        case 2: {
                            throw new RuntimeException("SEG_QUADTO: should not occur when shape.getPathIterator is passed a flatness argument");
                        }
                        case 3: {
                            throw new RuntimeException("SEG_CUBICTO: should not occur when shape.getPathIterator is passed a flatness argument");
                        }
                        default: {
                            throw new RuntimeException("unhandled segment: should not occur");
                        }
                    }
                    pi.next();
                }
            }
            finally {
                this.m_renderContext.gl.glDisable(2852);
                this.m_renderContext.gl.glLineWidth(1.0f);
            }
        } else {
            outlinesShape = this.m_stroke.createStrokedShape(s);
            PathIterator pi = outlinesShape.getPathIterator(null, 0.01);
            this.fill(pi);
        }
    }

    public void fill(Shape s) {
        this.fill(s.getPathIterator(null, 0.01));
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        throw new RuntimeException("not implemented");
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new RuntimeException("not implemented");
    }

    public Composite getComposite() {
        throw new RuntimeException("not implemented");
    }

    public void setComposite(Composite comp) {
        throw new RuntimeException("not implemented");
    }

    public Color getBackground() {
        return this.m_background;
    }

    public void setBackground(Color color) {
        this.m_background = color;
    }

    private void glSetColor(Color color) {
        assert (color != null);
        this.m_renderContext.gl.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
        if (color.getAlpha() != 255) {
            this.m_renderContext.gl.glEnable(3042);
            this.m_renderContext.gl.glBlendFunc(770, 771);
            this.m_renderContext.gl.glPixelTransferf(3356, (float)color.getAlpha() / 255.0f);
        } else {
            this.m_renderContext.gl.glDisable(3042);
            this.m_renderContext.gl.glPixelTransferf(3356, 1.0f);
        }
    }

    private void glSetPaint(Paint paint) {
        if (!(paint instanceof Color)) {
            throw new RuntimeException("not implemented");
        }
        this.glSetColor((Color)paint);
    }

    public Paint getPaint() {
        return this.m_paint;
    }

    public void setPaint(Paint paint) {
        if (!(paint instanceof Color)) {
            throw new RuntimeException("not implemented");
        }
        this.glSetColor((Color)paint);
        this.m_paint = paint;
    }

    public Stroke getStroke() {
        return this.m_stroke;
    }

    public void setStroke(Stroke stroke) {
        this.m_stroke = stroke;
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.m_renderingHints.get(hintKey);
    }

    public RenderingHints getRenderingHints() {
        return this.m_renderingHints;
    }

    public void addRenderingHints(Map hints) {
        this.m_renderingHints.add(new RenderingHints(hints));
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.m_renderingHints.put(hintKey, hintValue);
    }

    public void setRenderingHints(Map hints) {
        this.m_renderingHints = new RenderingHints(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void glUpdateTransform() {
        double[] dArray = s_matrix;
        synchronized (s_matrix) {
            this.m_affineTransform.getMatrix(s_matrix);
            if (s_matrix[4] != this.m_affineTransform.getTranslateX()) {
                System.err.println("WARNING: translate x: " + s_matrix[4] + " != " + this.m_affineTransform.getTranslateX());
            }
            if (s_matrix[5] != this.m_affineTransform.getTranslateY()) {
                System.err.println("WARNING: translate y: " + s_matrix[5] + " != " + this.m_affineTransform.getTranslateY());
            }
            this.m_glTransform[0] = s_matrix[0];
            this.m_glTransform[4] = s_matrix[2];
            this.m_glTransform[8] = 0.0;
            this.m_glTransform[12] = s_matrix[4];
            this.m_glTransform[1] = s_matrix[1];
            this.m_glTransform[5] = s_matrix[3];
            this.m_glTransform[9] = 0.0;
            this.m_glTransform[13] = s_matrix[5];
            this.m_glTransform[2] = 0.0;
            this.m_glTransform[6] = 0.0;
            this.m_glTransform[10] = 1.0;
            this.m_glTransform[14] = 0.0;
            this.m_glTransform[3] = 0.0;
            this.m_glTransform[7] = 0.0;
            this.m_glTransform[11] = 0.0;
            this.m_glTransform[15] = 1.0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.m_renderContext.gl.glLoadMatrixd(this.m_glTransformBuffer);
            return;
        }
    }

    public void translate(int x, int y) {
        this.m_affineTransform.translate(x, y);
        this.glUpdateTransform();
    }

    public void translate(double x, double y) {
        this.m_affineTransform.translate(x, y);
        this.glUpdateTransform();
    }

    public void rotate(double theta) {
        this.m_affineTransform.rotate(theta);
        this.glUpdateTransform();
    }

    public void rotate(double theta, double x, double y) {
        this.m_affineTransform.rotate(theta, x, y);
        this.glUpdateTransform();
    }

    public void scale(double sx, double sy) {
        this.m_affineTransform.scale(sx, sy);
        this.glUpdateTransform();
    }

    public void shear(double shx, double shy) {
        this.m_affineTransform.shear(shx, shy);
        this.glUpdateTransform();
    }

    public void transform(AffineTransform Tx) {
        this.m_affineTransform.concatenate(Tx);
        this.glUpdateTransform();
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.m_affineTransform);
    }

    public void setTransform(AffineTransform Tx) {
        this.m_affineTransform.setTransform(Tx);
        this.glUpdateTransform();
    }

    public void clip(Shape s) {
        throw new RuntimeException("not implemented");
    }

    public FontRenderContext getFontRenderContext() {
        boolean isAntiAliased = this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        boolean usesFractionalMetrics = this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS) == RenderingHints.VALUE_FRACTIONALMETRICS_ON;
        return new FontRenderContext(this.getTransform(), isAntiAliased, usesFractionalMetrics);
    }

    public boolean isRemembered(Font font) {
        return this.m_activeFontToTextRendererMap.containsKey(font);
    }

    public void remember(Font font) {
        ReferencedObject<TextRenderer> referencedObject = this.m_activeFontToTextRendererMap.get(font);
        if (referencedObject == null) {
            referencedObject = this.m_forgottenFontToTextRendererMap.get(font);
            if (referencedObject != null) {
                this.m_forgottenFontToTextRendererMap.remove(font);
            } else {
                TextRenderer glTextRenderer = new TextRenderer(font);
                referencedObject = new ReferencedObject<TextRenderer>(glTextRenderer, 0);
            }
            this.m_activeFontToTextRendererMap.put(font, referencedObject);
        }
        referencedObject.addReference();
    }

    public Rectangle2D getBounds(String text, Font font) {
        ReferencedObject<TextRenderer> referencedObject = this.m_activeFontToTextRendererMap.get(font);
        assert (referencedObject != null);
        assert (referencedObject.isReferenced());
        Rectangle2D bounds = referencedObject.getObject().getBounds(text);
        assert (bounds != null);
        return bounds;
    }

    public void forget(Font font) {
        ReferencedObject<TextRenderer> referencedObject = this.m_activeFontToTextRendererMap.get(font);
        assert (referencedObject != null);
        assert (referencedObject.isReferenced());
        referencedObject.removeReference();
        if (!referencedObject.isReferenced()) {
            this.m_activeFontToTextRendererMap.remove(font);
            this.m_forgottenFontToTextRendererMap.put(font, referencedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeForgottenFonts() {
        Map<Font, ReferencedObject<TextRenderer>> map = this.m_forgottenFontToTextRendererMap;
        synchronized (map) {
            for (Font font : this.m_forgottenFontToTextRendererMap.keySet()) {
                ReferencedObject<TextRenderer> referencedObject = this.m_forgottenFontToTextRendererMap.get(font);
                referencedObject.getObject().dispose();
            }
            this.m_forgottenFontToTextRendererMap.clear();
        }
    }

    public boolean isRemembered(ImageGenerator imageGenerator) {
        return this.m_activeImageGeneratorToPixelsMap.containsKey(imageGenerator);
    }

    public void remember(ImageGenerator imageGenerator) {
        assert (imageGenerator != null);
        ReferencedObject<Pixels> referencedObject = this.m_activeImageGeneratorToPixelsMap.get(imageGenerator);
        if (referencedObject == null) {
            referencedObject = this.m_forgottenImageGeneratorToPixelsMap.get(imageGenerator);
            if (referencedObject != null) {
                this.m_forgottenImageGeneratorToPixelsMap.remove(imageGenerator);
            } else if (imageGenerator instanceof Texture) {
                Texture texture = (Texture)imageGenerator;
                if (texture instanceof CustomTexture) {
                    ((CustomTexture)texture).layoutIfNecessary(this);
                }
                Pixels pixels = new Pixels((Texture)imageGenerator);
                referencedObject = new ReferencedObject<Pixels>(pixels, 0);
            } else {
                throw new RuntimeException("TODO");
            }
            this.m_activeImageGeneratorToPixelsMap.put(imageGenerator, referencedObject);
        }
        referencedObject.addReference();
    }

    public void paint(ImageGenerator imageGenerator, float x, float y, float alpha) {
        ReferencedObject<Pixels> referencedObject = this.m_activeImageGeneratorToPixelsMap.get(imageGenerator);
        assert (referencedObject != null);
        assert (referencedObject.isReferenced());
        Pixels pixels = referencedObject.getObject();
        if (imageGenerator.isAnimated()) {
            pixels.textureChanged(null);
        }
        this.m_renderContext.gl.glEnable(3042);
        this.m_renderContext.gl.glBlendFunc(770, 771);
        this.m_renderContext.gl.glPixelTransferf(3356, alpha);
        int xPixel = (int)x;
        int yPixel = (int)y + pixels.getHeight();
        this.m_renderContext.gl.glRasterPos2i(0, 0);
        this.m_renderContext.gl.glBitmap(0, 0, 0.0f, 0.0f, (float)xPixel, (float)(-yPixel), null);
        this.m_renderContext.gl.glDrawPixels(pixels.getWidth(), pixels.getHeight(), 6408, 5121, (Buffer)pixels.getRGBA());
        this.m_renderContext.gl.glDisable(3042);
        this.m_renderContext.gl.glPixelTransferf(3356, 1.0f);
    }

    public void forget(ImageGenerator imageGenerator) {
        ReferencedObject<Pixels> referencedObject = this.m_activeImageGeneratorToPixelsMap.get(imageGenerator);
        assert (referencedObject != null);
        assert (referencedObject.isReferenced());
        referencedObject.removeReference();
        if (!referencedObject.isReferenced()) {
            this.m_activeImageGeneratorToPixelsMap.remove(imageGenerator);
            this.m_forgottenImageGeneratorToPixelsMap.put(imageGenerator, referencedObject);
        }
    }

    private void disposeImageGenerator(ImageGenerator imageGenerator) {
        ReferencedObject<Pixels> referencedObject = this.m_forgottenImageGeneratorToPixelsMap.get(imageGenerator);
        referencedObject.getObject().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeForgottenImageGenerators() {
        Map<ImageGenerator, ReferencedObject<Pixels>> map = this.m_forgottenImageGeneratorToPixelsMap;
        synchronized (map) {
            for (ImageGenerator imageGenerator : this.m_forgottenImageGeneratorToPixelsMap.keySet()) {
                this.disposeImageGenerator(imageGenerator);
            }
            this.m_forgottenFontToTextRendererMap.clear();
        }
    }

    public boolean isRemembered(Image image) {
        ImageGenerator imageGenerator = this.m_imageToImageGeneratorMap.get(image);
        if (imageGenerator != null) {
            return this.isRemembered(imageGenerator);
        }
        return false;
    }

    public void remember(Image image) {
        ImageGenerator imageGenerator = this.m_imageToImageGeneratorMap.get(image);
        if (imageGenerator == null) {
            if (!(image instanceof BufferedImage)) {
                throw new RuntimeException("todo");
            }
            BufferedImage bufferedImage = (BufferedImage)image;
            BufferedImageTexture bufferedImageTexture = new BufferedImageTexture();
            bufferedImageTexture.setBufferedImage(bufferedImage);
            bufferedImageTexture.setMipMappingDesired(false);
            imageGenerator = bufferedImageTexture;
            this.m_imageToImageGeneratorMap.put(image, imageGenerator);
        }
        this.remember(imageGenerator);
    }

    public void forget(Image image) {
        ImageGenerator imageGenerator = this.m_imageToImageGeneratorMap.get(image);
        this.forget(imageGenerator);
    }

    public void disposeForgottenImages() {
        for (ImageGenerator imageGenerator : this.m_imageToImageGeneratorMap.values()) {
            if (!this.m_forgottenImageGeneratorToPixelsMap.containsKey(imageGenerator)) continue;
            this.disposeImageGenerator(imageGenerator);
            this.m_forgottenImageGeneratorToPixelsMap.remove(imageGenerator);
        }
    }

    public GL getGL() {
        return this.m_renderContext.gl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReferencedObject<E> {
        private E m_object;
        private int m_referenceCount;

        public ReferencedObject(E object, int referenceCount) {
            this.m_object = object;
            this.m_referenceCount = referenceCount;
        }

        public E getObject() {
            return this.m_object;
        }

        public boolean isReferenced() {
            return this.m_referenceCount > 0;
        }

        public void addReference() {
            ++this.m_referenceCount;
        }

        public void removeReference() {
            --this.m_referenceCount;
        }
    }
}

