/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.GeometryAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.VertexGeometryAdapter;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.IndexedPolygonArray;
import edu.cmu.cs.dennisc.scenegraph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedPolygonArrayAdapter<E extends IndexedPolygonArray>
extends VertexGeometryAdapter<E> {
    private float m_uRatio = Float.NaN;
    private float m_vRatio = Float.NaN;

    protected abstract int getMode();

    protected abstract int getIndicesPerPolygon();

    protected abstract void renderPolygon(RenderContext var1, int[] var2, int var3);

    protected abstract void pickPolygon(PickContext var1, int[] var2, int var3);

    @Override
    protected boolean isDisplayListInNeedOfRefresh(RenderContext rc) {
        float uRatio = rc.getURatio();
        float vRatio = rc.getVRatio();
        return super.isDisplayListInNeedOfRefresh(rc) || Float.compare(uRatio, this.m_uRatio) != 0 || Float.compare(vRatio, this.m_vRatio) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderGeometry(RenderContext rc) {
        float uRatio = rc.getURatio();
        float vRatio = rc.getVRatio();
        int[] polygonData = ((IndexedPolygonArray)this.m_element).polygonData.getValue();
        int mode = this.getMode();
        int indicesPerPolygon = this.getIndicesPerPolygon();
        rc.gl.glBegin(mode);
        try {
            for (int i = 0; i < polygonData.length; i += indicesPerPolygon) {
                this.renderPolygon(rc, polygonData, i);
            }
        }
        finally {
            rc.gl.glEnd();
        }
        this.m_uRatio = uRatio;
        this.m_vRatio = vRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pickGeometry(PickContext pc, boolean isSubElementRequired) {
        int mode = this.getMode();
        int indicesPerPolygon = this.getIndicesPerPolygon();
        int[] polygonData = ((IndexedPolygonArray)this.m_element).polygonData.getValue();
        pc.gl.glPushName(-1);
        if (isSubElementRequired) {
            int id = 0;
            for (int i = 0; i < polygonData.length; i += indicesPerPolygon) {
                pc.gl.glLoadName(id++);
                pc.gl.glBegin(mode);
                try {
                    this.pickPolygon(pc, polygonData, i);
                    continue;
                }
                finally {
                    pc.gl.glEnd();
                }
            }
        } else {
            pc.gl.glBegin(mode);
            try {
                for (int i = 0; i < polygonData.length; i += indicesPerPolygon) {
                    this.pickPolygon(pc, polygonData, i);
                }
            }
            finally {
                pc.gl.glEnd();
            }
        }
        pc.gl.glPopName();
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((IndexedPolygonArray)this.m_element).polygonData) {
            this.setIsGeometryChanged(true);
        } else {
            super.propertyChanged(property);
        }
    }

    @Override
    public Point3 getIntersectionInSource(Point3 rv, Ray ray, AffineMatrix4x4 m, int subElement) {
        if (subElement != -1) {
            int indicesPerPolygon = this.getIndicesPerPolygon();
            int[] polygonData = ((IndexedPolygonArray)this.m_element).polygonData.getValue();
            int index = subElement * indicesPerPolygon;
            if (0 <= index && index < polygonData.length) {
                Vertex v = this.accessVertexAt(polygonData[index]);
                GeometryAdapter.getIntersectionInSourceFromPlaneInLocal(rv, ray, m, v.position.x, v.position.y, v.position.z, v.normal.x, v.normal.y, v.normal.z);
            } else {
                rv.setNaN();
            }
        } else {
            rv.setNaN();
        }
        return rv;
    }
}

