/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.lookingglass.opengl.AffectorAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.AmbientLightAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.Light;
import java.nio.FloatBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LightAdapter<E extends Light>
extends AffectorAdapter<E> {
    private static FloatBuffer s_ambientBlackBuffer = null;
    private static float[] s_position = new float[4];
    private static FloatBuffer s_positionBuffer = FloatBuffer.wrap(s_position);
    private static float[] s_spotDirection = new float[3];
    private static FloatBuffer s_spotDirectionBuffer = FloatBuffer.wrap(s_spotDirection);
    private float[] m_color = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    private float m_brightness = Float.NaN;

    protected float[] getPosition(float[] rv) {
        rv[0] = 0.0f;
        rv[1] = 0.0f;
        rv[2] = 1.0f;
        rv[3] = 0.0f;
        return rv;
    }

    protected float[] getSpotDirection(float[] rv) {
        rv[0] = 0.0f;
        rv[1] = 0.0f;
        rv[2] = -1.0f;
        return rv;
    }

    protected float getSpotExponent() {
        return 0.0f;
    }

    protected float getSpotCutoff() {
        return 180.0f;
    }

    protected float getConstantAttenuation() {
        return 1.0f;
    }

    protected float getLinearAttenuation() {
        return 0.0f;
    }

    protected float getQuadraticAttenuation() {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup(RenderContext rc, int id) {
        rc.gl.glEnable(id);
        if (s_ambientBlackBuffer == null) {
            s_ambientBlackBuffer = FloatBuffer.allocate(4);
            s_ambientBlackBuffer.put(0.0f);
            s_ambientBlackBuffer.put(0.0f);
            s_ambientBlackBuffer.put(0.0f);
            s_ambientBlackBuffer.put(1.0f);
            s_ambientBlackBuffer.rewind();
        }
        rc.gl.glLightfv(id, 4608, s_ambientBlackBuffer);
        rc.setLightColor(id, this.m_color, this.m_brightness);
        float[] fArray = s_position;
        synchronized (s_position) {
            this.getPosition(s_position);
            rc.gl.glLightfv(id, 4611, s_positionBuffer);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            fArray = s_spotDirection;
            synchronized (s_spotDirection) {
                this.getSpotDirection(s_spotDirection);
                rc.gl.glLightfv(id, 4612, s_spotDirectionBuffer);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                rc.gl.glLightf(id, 4613, this.getSpotExponent());
                rc.gl.glLightf(id, 4614, this.getSpotCutoff());
                rc.gl.glLightf(id, 4615, this.getConstantAttenuation());
                rc.gl.glLightf(id, 4616, this.getLinearAttenuation());
                rc.gl.glLightf(id, 4617, this.getQuadraticAttenuation());
                return;
            }
        }
    }

    @Override
    public void setup(RenderContext rc) {
        if (this instanceof AmbientLightAdapter) {
            rc.addAmbient(this.m_color, this.m_brightness);
        } else {
            int id = rc.getNextLightID();
            this.setup(rc, id);
        }
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Light)this.m_element).color) {
            ((Color4f)((Light)this.m_element).color.getValue()).getAsArray(this.m_color);
        } else if (property == ((Light)this.m_element).brightness) {
            this.m_brightness = ((Float)((Light)this.m_element).brightness.getValue()).floatValue();
        } else {
            super.propertyChanged(property);
        }
    }
}

