/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

class MyTessAdapter
extends GLUtessellatorCallbackAdapter {
    private GL m_gl;
    private GLU m_glu;
    private double m_xOffset;
    private double m_yOffset;
    private double m_z;
    private boolean m_isFront;

    MyTessAdapter() {
    }

    private String getErrorString(int error) {
        switch (error) {
            case 100151: {
                return "GLU_TESS_MISSING_BEGIN_POLYGON";
            }
            case 100153: {
                return "GLU_TESS_MISSING_END_POLYGON";
            }
            case 100152: {
                return "GLU_TESS_MISSING_BEGIN_CONTOUR";
            }
            case 100154: {
                return "GLU_TESS_MISSING_END_CONTOUR";
            }
            case 100155: {
                return "GLU_TESS_COORD_TOO_LARGE";
            }
            case 100156: {
                return "GLU_TESS_NEED_COMBINE_CALLBACK";
            }
            case 100902: {
                return "GLU_OUT_OF_MEMORY";
            }
        }
        return "UNKNOWN";
    }

    public void set(GL gl, GLU glu, double xOffset, double yOffset, double z, boolean isFront) {
        this.m_gl = gl;
        this.m_glu = glu;
        this.m_xOffset = xOffset;
        this.m_yOffset = yOffset;
        this.m_z = z;
        this.m_isFront = isFront;
    }

    public void begin(int primitiveType) {
        this.m_gl.glBegin(primitiveType);
        if (this.m_isFront) {
            this.m_gl.glNormal3d(0.0, 0.0, -1.0);
        } else {
            this.m_gl.glNormal3d(0.0, 0.0, 1.0);
        }
    }

    public void vertex(Object data) {
        double[] vertex = (double[])data;
        this.m_gl.glVertex3d(vertex[0] + this.m_xOffset, vertex[1] + this.m_yOffset, this.m_z);
    }

    public void end() {
        this.m_gl.glEnd();
    }

    public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
        outData[0] = new double[]{coords[0], coords[1], coords[2]};
    }

    public void error(int arg0) {
        super.error(arg0);
    }
}

