/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractNearPlaneAndFarPlaneCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.math.ClippedZPlane;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.OrthographicCamera;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthographicCameraAdapter
extends AbstractNearPlaneAndFarPlaneCameraAdapter<OrthographicCamera> {
    private static ClippedZPlane s_actualPicturePlaneBufferForReuse = new ClippedZPlane(Double.NaN, Double.NaN, Double.NaN, Double.NaN);

    @Override
    public Ray getRayAtPixel(Ray rv, int xPixel, int yPixel, Rectangle actualViewport) {
        throw new RuntimeException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Matrix4x4 getActualProjectionMatrix(Matrix4x4 rv, Rectangle actualViewport) {
        ClippedZPlane clippedZPlane = s_actualPicturePlaneBufferForReuse;
        synchronized (clippedZPlane) {
            ClippedZPlane actualPicturePlane = this.getActualPicturePlane(new ClippedZPlane(), actualViewport);
            double left = actualPicturePlane.getXMinimum();
            double right = actualPicturePlane.getXMaximum();
            double bottom = actualPicturePlane.getYMinimum();
            double top = actualPicturePlane.getYMaximum();
            double near = (Double)((OrthographicCamera)this.m_element).nearClippingPlaneDistance.getValue();
            double far = (Double)((OrthographicCamera)this.m_element).farClippingPlaneDistance.getValue();
            rv.setIdentity();
            rv.right.x = 2.0 / (right - left);
            rv.up.y = 2.0 / (top - bottom);
            rv.backward.z = 2.0 / (far - near);
            rv.translation.x = (right + left) / (right - left);
            rv.translation.y = (top + bottom) / (top - bottom);
            rv.translation.z = (far + near) / (far - near);
        }
        return rv;
    }

    @Override
    protected Rectangle performLetterboxing(Rectangle rv) {
        return rv;
    }

    protected ClippedZPlane getActualPicturePlane(ClippedZPlane rv, Rectangle actualViewport) {
        rv.set((ClippedZPlane)((OrthographicCamera)this.m_element).picturePlane.getValue(), actualViewport);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupProjection(Context context, Rectangle actualViewport, float near, float far) {
        ClippedZPlane clippedZPlane = s_actualPicturePlaneBufferForReuse;
        synchronized (clippedZPlane) {
            this.getActualPicturePlane(s_actualPicturePlaneBufferForReuse, actualViewport);
            context.gl.glOrtho(s_actualPicturePlaneBufferForReuse.getXMinimum(), s_actualPicturePlaneBufferForReuse.getXMaximum(), s_actualPicturePlaneBufferForReuse.getYMinimum(), s_actualPicturePlaneBufferForReuse.getYMaximum(), (double)near, (double)far);
        }
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property != ((OrthographicCamera)this.m_element).picturePlane) {
            super.propertyChanged(property);
        }
    }
}

