/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.texture.BufferedImageTexture;
import edu.cmu.cs.dennisc.texture.CustomTexture;
import edu.cmu.cs.dennisc.texture.Texture;
import edu.cmu.cs.dennisc.texture.event.TextureEvent;
import edu.cmu.cs.dennisc.texture.event.TextureListener;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;

class Pixels
implements TextureListener {
    private static final ComponentColorModel RGBA_COLOR_MODEL = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    private Texture m_texture;
    private WritableRaster m_writableRaster = null;
    private BufferedImage m_bufferedImage = null;
    private ByteBuffer m_data = null;

    public Pixels(Texture texture) {
        this.m_texture = texture;
        this.m_texture.addTextureListener(this);
    }

    public void textureChanged(TextureEvent textureEvent) {
        if (this.m_texture != null && this.m_writableRaster != null && this.m_bufferedImage != null && (this.m_texture.getWidth() != this.m_bufferedImage.getWidth() || this.m_texture.getHeight() != this.m_bufferedImage.getHeight())) {
            this.touchImage();
        }
    }

    public void touchImage() {
        this.m_data = null;
        if (this.m_writableRaster != null && (this.m_texture.getWidth() != this.m_writableRaster.getWidth() || this.m_texture.getHeight() != this.m_writableRaster.getHeight())) {
            this.m_writableRaster = null;
            this.m_bufferedImage = null;
        }
    }

    public void release() {
        if (this.m_texture != null) {
            this.m_texture.removeTextureListener(this);
            this.m_writableRaster = null;
            this.m_bufferedImage = null;
            this.m_data = null;
            this.m_texture = null;
        }
    }

    public int getWidth() {
        return this.m_texture.getWidth();
    }

    public int getHeight() {
        return this.m_texture.getHeight();
    }

    private BufferedImage getBufferedImage() {
        if (this.m_bufferedImage == null) {
            this.m_writableRaster = Raster.createInterleavedRaster(0, this.getWidth(), this.getHeight(), 4, null);
            this.m_bufferedImage = new BufferedImage(RGBA_COLOR_MODEL, this.m_writableRaster, false, null);
        }
        return this.m_bufferedImage;
    }

    public ByteBuffer getRGBA() {
        if (this.m_data == null) {
            BufferedImage bufferedImage = this.getBufferedImage();
            if (bufferedImage != null) {
                Graphics2D g = bufferedImage.createGraphics();
                AffineTransform gt = new AffineTransform();
                gt.translate(0.0, bufferedImage.getHeight());
                gt.scale(1.0, -1.0);
                g.transform(gt);
                if (this.m_texture instanceof BufferedImageTexture) {
                    BufferedImageTexture bufferedImageTexture = (BufferedImageTexture)this.m_texture;
                    g.drawImage(bufferedImageTexture.getBufferedImage(), null, null);
                } else if (this.m_texture instanceof CustomTexture) {
                    CustomTexture customTexture = (CustomTexture)this.m_texture;
                    customTexture.paint(g, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
                g.dispose();
                DataBufferByte dataBufferByte = (DataBufferByte)this.m_writableRaster.getDataBuffer();
                byte[] data = dataBufferByte.getData();
                this.m_data = ByteBuffer.wrap(data);
            } else {
                this.m_data = null;
            }
        }
        return this.m_data;
    }
}

