/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.BackgroundAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.ComponentAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.CompositeAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.GhostAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PlanarReflectorAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.VisualAdapter;
import edu.cmu.cs.dennisc.pattern.VisitUtilities;
import edu.cmu.cs.dennisc.pattern.Visitable;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Scene;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneAdapter
extends CompositeAdapter<Scene> {
    private BackgroundAdapter m_backgroundAdapter = null;
    private float m_globalBrightness;
    private Vector<GhostAdapter> m_ghostAdapters = new Vector();
    protected Vector<VisualAdapter<? extends Visual>> m_visualAdapters = new Vector();
    private Vector<PlanarReflectorAdapter> m_planarReflectorAdapters = new Vector();

    @Override
    public void initialize(Scene sgElement) {
        super.initialize(sgElement);
        for (Component sgComponent : VisitUtilities.getAll((Visitable)((Object)this.m_element), Component.class)) {
            this.addDescendant(AdapterFactory.getAdapterFor(sgComponent));
        }
    }

    public BackgroundAdapter getBackgroundAdapter() {
        return this.m_backgroundAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescendant(ComponentAdapter<? extends Component> componentAdapter) {
        if (componentAdapter instanceof GhostAdapter) {
            Vector<GhostAdapter> vector = this.m_ghostAdapters;
            synchronized (vector) {
                this.m_ghostAdapters.add((GhostAdapter)componentAdapter);
            }
        }
        if (componentAdapter instanceof VisualAdapter) {
            Vector<VisualAdapter<? extends Visual>> vector = this.m_visualAdapters;
            synchronized (vector) {
                this.m_visualAdapters.add((VisualAdapter)componentAdapter);
            }
            if (componentAdapter instanceof PlanarReflectorAdapter) {
                vector = this.m_planarReflectorAdapters;
                synchronized (vector) {
                    this.m_planarReflectorAdapters.add((PlanarReflectorAdapter)componentAdapter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescendant(ComponentAdapter<? extends Component> componentAdapter) {
        if (componentAdapter instanceof GhostAdapter) {
            Vector<GhostAdapter> vector = this.m_ghostAdapters;
            synchronized (vector) {
                this.m_ghostAdapters.remove((GhostAdapter)componentAdapter);
            }
        }
        if (componentAdapter instanceof VisualAdapter) {
            Vector<VisualAdapter<? extends Visual>> vector = this.m_visualAdapters;
            synchronized (vector) {
                this.m_visualAdapters.remove((VisualAdapter)componentAdapter);
            }
            if (componentAdapter instanceof PlanarReflectorAdapter) {
                vector = this.m_planarReflectorAdapters;
                synchronized (vector) {
                    this.m_planarReflectorAdapters.remove((PlanarReflectorAdapter)componentAdapter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAlphaBlended(RenderContext rc) {
        Vector<ComponentAdapter> vector = this.m_ghostAdapters;
        synchronized (vector) {
            for (GhostAdapter ghostAdapter : this.m_ghostAdapters) {
                ghostAdapter.renderGhost(rc, ghostAdapter);
            }
        }
        vector = this.m_visualAdapters;
        synchronized (vector) {
            for (VisualAdapter visualAdapter : this.m_visualAdapters) {
                if (!visualAdapter.isAlphaBlended()) continue;
                visualAdapter.renderAlphaBlended(rc);
            }
        }
    }

    @Override
    public void setup(RenderContext rc) {
        rc.setGlobalBrightness(this.m_globalBrightness);
        rc.beginAffectorSetup();
        super.setup(rc);
        rc.endAffectorSetup();
    }

    private void renderScene(RenderContext rc) {
        rc.gl.glDisable(3042);
        this.renderOpaque(rc);
        rc.gl.glEnable(3042);
        rc.gl.glBlendFunc(770, 771);
        this.renderAlphaBlended(rc);
        rc.gl.glDisable(3042);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderScene(RenderContext rc, AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter, BackgroundAdapter backgroundAdapter) {
        rc.gl.glMatrixMode(5888);
        AbstractCameraAdapter<? extends AbstractCamera> abstractCameraAdapter = cameraAdapter;
        synchronized (abstractCameraAdapter) {
            rc.gl.glLoadMatrixd(cameraAdapter.accessInverseAbsoluteTransformationAsBuffer());
        }
        if (backgroundAdapter == null) {
            backgroundAdapter = this.m_backgroundAdapter;
        }
        if (backgroundAdapter != null) {
            backgroundAdapter.setup(rc);
        }
        if (this.m_planarReflectorAdapters.size() > 0) {
            PlanarReflectorAdapter planarReflectorAdapter = this.m_planarReflectorAdapters.get(0);
            if (planarReflectorAdapter.isFacing(cameraAdapter)) {
                rc.gl.glClear(17664);
                rc.gl.glColorMask(false, false, false, false);
                rc.gl.glEnable(2960);
                rc.gl.glStencilFunc(519, 1, 1);
                rc.gl.glStencilOp(7680, 7680, 7681);
                rc.gl.glDisable(2929);
                planarReflectorAdapter.renderStencil(rc);
                rc.gl.glEnable(2929);
                rc.gl.glColorMask(true, true, true, true);
                rc.gl.glStencilFunc(514, 1, 1);
                rc.gl.glStencilOp(7680, 7680, 7680);
                rc.gl.glEnable(12288);
                rc.gl.glPushMatrix();
                planarReflectorAdapter.applyReflection(rc);
                rc.gl.glFrontFace(2304);
                this.setup(rc);
                this.renderScene(rc);
                rc.gl.glFrontFace(2305);
                rc.gl.glPopMatrix();
                rc.gl.glDisable(12288);
                rc.gl.glDisable(2960);
                this.setup(rc);
                rc.gl.glEnable(3042);
                rc.gl.glBlendFunc(770, 771);
                planarReflectorAdapter.renderStencil(rc);
                rc.gl.glDisable(3042);
            } else {
                rc.gl.glClear(16640);
                this.setup(rc);
            }
        } else {
            rc.gl.glClear(16640);
            this.setup(rc);
        }
        this.renderScene(rc);
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Scene)this.m_element).background) {
            this.m_backgroundAdapter = AdapterFactory.getAdapterFor(((Scene)this.m_element).background.getValue());
        } else if (property == ((Scene)this.m_element).globalBrightness) {
            this.m_globalBrightness = ((Float)((Scene)this.m_element).globalBrightness.getValue()).floatValue();
        } else {
            super.propertyChanged(property);
        }
    }
}

