/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.lookingglass.opengl.GeometryAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.MyTessAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point2f;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.Text;
import java.util.Vector;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAdapter
extends GeometryAdapter<Text> {
    private static MyTessAdapter s_tessAdapter = new MyTessAdapter();

    @Override
    public boolean isAlphaBlended() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFaceContours(Context context, double xOffset, double yOffset, double z, boolean isFront) {
        MyTessAdapter myTessAdapter = s_tessAdapter;
        synchronized (myTessAdapter) {
            Vector<Vector<Point2f>> faceContours = ((Text)this.m_element).getGlyphVector().acquireFaceContours();
            s_tessAdapter.set(context.gl, context.glu, xOffset, yOffset, z, isFront);
            GLUtessellator tesselator = context.glu.gluNewTess();
            context.glu.gluTessCallback(tesselator, 100100, (GLUtessellatorCallback)s_tessAdapter);
            context.glu.gluTessCallback(tesselator, 100101, (GLUtessellatorCallback)s_tessAdapter);
            context.glu.gluTessCallback(tesselator, 100102, (GLUtessellatorCallback)s_tessAdapter);
            context.glu.gluTessCallback(tesselator, 100105, (GLUtessellatorCallback)s_tessAdapter);
            context.glu.gluTessCallback(tesselator, 100103, (GLUtessellatorCallback)s_tessAdapter);
            try {
                context.glu.gluBeginPolygon(tesselator);
                try {
                    for (Vector<Point2f> faceContour : faceContours) {
                        context.glu.gluTessBeginContour(tesselator);
                        try {
                            int n = faceContour.size();
                            for (int i = 0; i < n; ++i) {
                                Point2f p = isFront ? faceContour.elementAt(n - i - 1) : faceContour.elementAt(i);
                                double[] xyz = new double[]{p.x, p.y, 0.0};
                                context.glu.gluTessVertex(tesselator, xyz, 0, (Object)xyz);
                            }
                        }
                        finally {
                            context.glu.gluTessEndContour(tesselator);
                        }
                    }
                }
                finally {
                    context.glu.gluTessEndPolygon(tesselator);
                }
            }
            finally {
                ((Text)this.m_element).getGlyphVector().releaseFaceContours();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void glText(Context context, boolean isLightingEnabled) {
        Vector3 alignmentOffset = ((Text)this.m_element).getAlignmentOffset();
        double zFront = alignmentOffset.z;
        double zBack = zFront + (Double)((Text)this.m_element).depth.getValue();
        this.renderFaceContours(context, alignmentOffset.x, alignmentOffset.y, zFront, true);
        this.renderFaceContours(context, alignmentOffset.x, alignmentOffset.y, zBack, false);
        if (zFront != zBack) {
            Vector<Vector<Point2f>> outlineLines = ((Text)this.m_element).getGlyphVector().acquireOutlineLines();
            try {
                for (Vector<Point2f> outlineLine : outlineLines) {
                    context.gl.glBegin(8);
                    Point2f prev = null;
                    for (Point2f curr : outlineLine) {
                        if (prev != null && (curr.x != prev.x || curr.y != prev.y)) {
                            if (isLightingEnabled) {
                                double xDelta = curr.x - prev.x;
                                double yDelta = curr.y - prev.y;
                                double lengthSquared = xDelta * xDelta + yDelta * yDelta;
                                double length = Math.sqrt(lengthSquared);
                                context.gl.glNormal3d(yDelta / length, xDelta / length, 0.0);
                            }
                            context.gl.glVertex3d((double)prev.x + alignmentOffset.x, (double)prev.y + alignmentOffset.y, zFront);
                            context.gl.glVertex3d((double)prev.x + alignmentOffset.x, (double)prev.y + alignmentOffset.y, zBack);
                        }
                        prev = curr;
                    }
                    context.gl.glVertex3d((double)prev.x + alignmentOffset.x, (double)prev.y + alignmentOffset.y, zFront);
                    context.gl.glVertex3d((double)prev.x + alignmentOffset.x, (double)prev.y + alignmentOffset.y, zBack);
                    context.gl.glEnd();
                }
            }
            finally {
                ((Text)this.m_element).getGlyphVector().releaseOutlineLines();
            }
        }
    }

    @Override
    protected void renderGeometry(RenderContext rc) {
        this.glText(rc, true);
    }

    @Override
    protected void pickGeometry(PickContext pc, boolean isSubElementRequired) {
        int name = isSubElementRequired ? 0 : -1;
        pc.gl.glPushName(name);
        this.glText(pc, false);
        pc.gl.glPopName();
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Text)this.m_element).text) {
            this.setIsGeometryChanged(true);
        } else if (property == ((Text)this.m_element).font) {
            this.setIsGeometryChanged(true);
        } else if (property == ((Text)this.m_element).depth) {
            this.setIsGeometryChanged(true);
        } else if (property == ((Text)this.m_element).leftToRightAlignment) {
            this.setIsGeometryChanged(true);
        } else if (property == ((Text)this.m_element).topToBottomAlignment) {
            this.setIsGeometryChanged(true);
        } else if (property == ((Text)this.m_element).frontToBackAlignment) {
            this.setIsGeometryChanged(true);
        } else {
            super.propertyChanged(property);
        }
    }

    @Override
    public Point3 getIntersectionInSource(Point3 rv, Ray ray, AffineMatrix4x4 m, int subElement) {
        Vector3 alignmentOffset = ((Text)this.m_element).getAlignmentOffset();
        double zFront = alignmentOffset.z;
        return GeometryAdapter.getIntersectionInSourceFromPlaneInLocal(rv, ray, m, 0.0, 0.0, zFront, 0.0, 0.0, -1.0);
    }
}

