/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractElementAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.texture.Texture;
import edu.cmu.cs.dennisc.texture.event.TextureEvent;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextureAdapter<E extends Texture>
extends AbstractElementAdapter<E> {
    private List<RenderContext> m_renderContexts = new LinkedList<RenderContext>();
    private boolean m_isDirty = true;
    private com.sun.opengl.util.texture.Texture m_glTexture;

    public static void handleTextureChanged(TextureEvent e) {
        TextureAdapter<? extends Texture> textureAdapter = AdapterFactory.getAdapterFor((Texture)e.getTypedSource());
        super.handleTextureChanged();
    }

    public boolean isPotentiallyAlphaBlended() {
        return ((Texture)this.m_element).isPotentiallyAlphaBlended();
    }

    public boolean isValid() {
        if (this.m_element != null) {
            return ((Texture)this.m_element).isValid();
        }
        return false;
    }

    public void addRenderContext(RenderContext rc) {
        this.m_renderContexts.add(rc);
    }

    public void removeRenderContext(RenderContext rc) {
        this.m_renderContexts.remove(rc);
        this.setDirty(true);
    }

    @Override
    public void handleReleased() {
        super.handleReleased();
        if (this.m_renderContexts.size() > 0) {
            RenderContext[] renderContexts = new RenderContext[this.m_renderContexts.size()];
            this.m_renderContexts.toArray(renderContexts);
            for (RenderContext rc : renderContexts) {
                rc.forgetTextureAdapter(this, true);
            }
        }
    }

    private void handleTextureChanged() {
        this.setDirty(true);
    }

    protected boolean isDirty() {
        return this.m_isDirty;
    }

    protected void setDirty(boolean isDirty) {
        this.m_isDirty = isDirty;
    }

    public float mapU(float u) {
        return u;
    }

    public float mapV(float v) {
        return v;
    }

    protected abstract com.sun.opengl.util.texture.Texture newTexture(com.sun.opengl.util.texture.Texture var1);

    public com.sun.opengl.util.texture.Texture getTexture(RenderContext rc) {
        int textureObject;
        boolean isNewTextureRequired = this.m_glTexture != null ? (this.isDirty() ? true : !rc.gl.glIsTexture(textureObject = this.m_glTexture.getTextureObject())) : true;
        if (isNewTextureRequired) {
            com.sun.opengl.util.texture.Texture glTexture = this.newTexture(this.m_glTexture);
            if (this.m_glTexture != glTexture) {
                if (this.m_glTexture != null) {
                    this.m_glTexture.dispose();
                }
                this.m_glTexture = glTexture;
                rc.put(this, this.m_glTexture);
            }
            this.m_isDirty = false;
        }
        return this.m_glTexture;
    }

    public abstract Graphics2D createGraphics();

    public abstract void commitGraphics(Graphics2D var1, int var2, int var3, int var4, int var5);

    public abstract Image getImage();
}

