/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.AppearanceAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.ConformanceTestResults;
import edu.cmu.cs.dennisc.lookingglass.opengl.GeometryAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.GhostAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.LeafAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickParameters;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.pattern.AbstractElement;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.Appearance;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import java.nio.DoubleBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualAdapter<E extends Visual>
extends LeafAdapter<E> {
    protected AppearanceAdapter<? extends Appearance> m_frontFacingAppearanceAdapter = null;
    private AppearanceAdapter<? extends Appearance> m_backFacingAppearanceAdapter = null;
    private boolean m_isShowing = false;
    private double[] m_scale = new double[16];
    protected DoubleBuffer m_scaleBuffer = DoubleBuffer.wrap(this.m_scale);
    protected boolean m_isScaleIdentity = true;
    protected GeometryAdapter<? extends Geometry>[] m_geometryAdapters = null;

    public Point3 getIntersectionInSource(Point3 rv, Ray ray, AffineMatrix4x4 inverseAbsoluteTransformationOfSource, int geometryIndex, int subElement) {
        if (0 <= geometryIndex && geometryIndex < this.m_geometryAdapters.length) {
            AffineMatrix4x4 absoluteTransformation = ((Visual)this.m_element).getAbsoluteTransformation();
            AffineMatrix4x4 m = AffineMatrix4x4.createMultiplication(inverseAbsoluteTransformationOfSource, absoluteTransformation);
            this.m_geometryAdapters[geometryIndex].getIntersectionInSource(rv, ray, m, subElement);
        }
        return rv;
    }

    private boolean isEthereal() {
        if (this.m_frontFacingAppearanceAdapter != null && !this.m_frontFacingAppearanceAdapter.isEthereal()) {
            return false;
        }
        return this.m_backFacingAppearanceAdapter == null || this.m_backFacingAppearanceAdapter.isEthereal();
        {
        }
    }

    protected boolean isActuallyShowing() {
        if (this.m_isShowing && this.m_geometryAdapters != null && this.m_geometryAdapters.length > 0) {
            if (this.m_frontFacingAppearanceAdapter != null && this.m_frontFacingAppearanceAdapter.isActuallyShowing()) {
                return true;
            }
            if (this.m_backFacingAppearanceAdapter != null && this.m_backFacingAppearanceAdapter.isActuallyShowing()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isAlphaBlended() {
        if (this.m_geometryAdapters == null || this.m_geometryAdapters.length <= 0) return false;
        GeometryAdapter<? extends Geometry>[] geometryAdapterArray = this.m_geometryAdapters;
        synchronized (this.m_geometryAdapters) {
            for (GeometryAdapter<? extends Geometry> geometryAdapter : this.m_geometryAdapters) {
                if (!geometryAdapter.isAlphaBlended()) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.m_frontFacingAppearanceAdapter != null && this.m_frontFacingAppearanceAdapter.isAlphaBlended()) {
                return true;
            }
            if (this.m_backFacingAppearanceAdapter == null || !this.m_backFacingAppearanceAdapter.isAlphaBlended()) return false;
            return true;
        }
    }

    private void updateScale(Matrix3x3 m) {
        this.m_isScaleIdentity = m.isIdentity();
        m.getAsColumnMajorArray16(this.m_scale);
    }

    @Override
    public void setup(RenderContext rc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void actuallyRender(RenderContext rc) {
        assert (this.m_frontFacingAppearanceAdapter != null || this.m_backFacingAppearanceAdapter != null);
        if (this.m_isScaleIdentity) {
            rc.gl.glDisable(2977);
        } else {
            rc.gl.glPushMatrix();
            rc.gl.glMultMatrixd(this.m_scaleBuffer);
            rc.gl.glEnable(2977);
        }
        if (this.m_frontFacingAppearanceAdapter == this.m_backFacingAppearanceAdapter) {
            if (this.m_frontFacingAppearanceAdapter != null) {
                this.m_frontFacingAppearanceAdapter.setPipelineState(rc, 1032);
                rc.gl.glDisable(2884);
                GeometryAdapter<? extends Geometry>[] geometryAdapterArray = this.m_geometryAdapters;
                // MONITORENTER : this.m_geometryAdapters
                for (GeometryAdapter<? extends Geometry> geometryAdapter : this.m_geometryAdapters) {
                    geometryAdapter.render(rc);
                }
                // MONITOREXIT : geometryAdapterArray
                rc.gl.glEnable(2884);
            }
        } else {
            GeometryAdapter<? extends Geometry>[] geometryAdapterArray;
            if (this.m_frontFacingAppearanceAdapter != null) {
                rc.gl.glCullFace(1029);
                this.m_frontFacingAppearanceAdapter.setPipelineState(rc, 1028);
                geometryAdapterArray = this.m_geometryAdapters;
                // MONITORENTER : this.m_geometryAdapters
                for (GeometryAdapter<? extends Geometry> geometryAdapter : this.m_geometryAdapters) {
                    geometryAdapter.render(rc);
                }
                // MONITOREXIT : geometryAdapterArray
            }
            if (this.m_backFacingAppearanceAdapter != null) {
                rc.gl.glCullFace(1028);
                this.m_backFacingAppearanceAdapter.setPipelineState(rc, 1029);
                geometryAdapterArray = this.m_geometryAdapters;
                // MONITORENTER : this.m_geometryAdapters
                for (GeometryAdapter<? extends Geometry> geometryAdapter : this.m_geometryAdapters) {
                    geometryAdapter.render(rc);
                }
                // MONITOREXIT : geometryAdapterArray
            }
        }
        if (this.m_isScaleIdentity) {
            return;
        }
        rc.gl.glPopMatrix();
    }

    public void renderAlphaBlended(RenderContext rc) {
        if (this.isActuallyShowing()) {
            rc.gl.glPushMatrix();
            rc.gl.glMultMatrixd(this.accessAbsoluteTransformationAsBuffer());
            this.actuallyRender(rc);
            rc.gl.glPopMatrix();
        }
    }

    @Override
    public void renderOpaque(RenderContext rc) {
        if (this.isActuallyShowing() && !this.isAlphaBlended()) {
            this.actuallyRender(rc);
        }
    }

    @Override
    public void renderGhost(RenderContext rc, GhostAdapter root) {
        this.actuallyRender(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void pick(PickContext pc, PickParameters pickParameters, ConformanceTestResults conformanceTestResults) {
        int i;
        GeometryAdapter<? extends Geometry>[] geometryAdapterArray;
        boolean isSubElementActuallyRequired;
        if (!this.isActuallyShowing()) return;
        if (this.isEthereal()) return;
        boolean bl = isSubElementActuallyRequired = pickParameters.isSubElementRequired() || !conformanceTestResults.isPickFunctioningCorrectly();
        if (!this.m_isScaleIdentity) {
            pc.gl.glPushMatrix();
            pc.gl.glMultMatrixd(this.m_scaleBuffer);
        }
        pc.gl.glPushName(pc.getPickNameForVisualAdapter(this));
        pc.gl.glEnable(2884);
        if (this.m_backFacingAppearanceAdapter != null) {
            pc.gl.glCullFace(1028);
            pc.gl.glPushName(0);
            geometryAdapterArray = this.m_geometryAdapters;
            // MONITORENTER : this.m_geometryAdapters
            for (i = 0; i < this.m_geometryAdapters.length; ++i) {
                pc.gl.glPushName(i);
                this.m_geometryAdapters[i].pick(pc, isSubElementActuallyRequired);
                pc.gl.glPopName();
            }
            // MONITOREXIT : geometryAdapterArray
            pc.gl.glPopName();
        }
        if (this.m_frontFacingAppearanceAdapter != null) {
            pc.gl.glCullFace(1029);
            pc.gl.glPushName(1);
            geometryAdapterArray = this.m_geometryAdapters;
            // MONITORENTER : this.m_geometryAdapters
            for (i = 0; i < this.m_geometryAdapters.length; ++i) {
                pc.gl.glPushName(i);
                this.m_geometryAdapters[i].pick(pc, isSubElementActuallyRequired);
                pc.gl.glPopName();
            }
            // MONITOREXIT : geometryAdapterArray
            pc.gl.glPopName();
        }
        pc.gl.glPopName();
        if (this.m_isScaleIdentity) {
            return;
        }
        pc.gl.glPopMatrix();
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Visual)this.m_element).geometries) {
            this.m_geometryAdapters = (GeometryAdapter[])AdapterFactory.getAdaptersFor((AbstractElement[])((AbstractElement[])((Visual)this.m_element).geometries.getValue()), GeometryAdapter.class);
        } else if (property == ((Visual)this.m_element).frontFacingAppearance) {
            this.m_frontFacingAppearanceAdapter = AdapterFactory.getAdapterFor(((Visual)this.m_element).frontFacingAppearance.getValue());
        } else if (property == ((Visual)this.m_element).backFacingAppearance) {
            this.m_backFacingAppearanceAdapter = AdapterFactory.getAdapterFor(((Visual)this.m_element).backFacingAppearance.getValue());
        } else if (property == ((Visual)this.m_element).scale) {
            this.updateScale((Matrix3x3)((Visual)this.m_element).scale.getValue());
        } else if (property == ((Visual)this.m_element).isShowing) {
            this.m_isShowing = (Boolean)((Visual)this.m_element).isShowing.getValue();
        } else {
            super.propertyChanged(property);
        }
    }
}

