/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl.graphics;

import edu.cmu.cs.dennisc.awt.TextAlignment;
import edu.cmu.cs.dennisc.awt.geom.Composite;
import edu.cmu.cs.dennisc.awt.geom.Ellipse;
import edu.cmu.cs.dennisc.awt.geom.MultilineText;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.SineCosineCache;
import edu.cmu.cs.dennisc.random.RandomUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.LinkedList;

class BumpyBubble
extends Composite {
    private String m_message;
    private Font m_font;
    private static final double PI_TIMES_2 = Math.PI * 2;
    private static SineCosineCache s_sineCosineCache = new SineCosineCache(8);

    BumpyBubble() {
    }

    private static double getLengthSquared(double x, double y) {
        return x * x + y * y;
    }

    private static double getLength(double x, double y) {
        return Math.sqrt(BumpyBubble.getLengthSquared(x, y));
    }

    private static double getDistanceBetween(double theta0, double theta1, double xHalfLength, double yHalfLength) {
        double x0 = xHalfLength * Math.cos(theta0);
        double y0 = yHalfLength * Math.sin(theta0);
        double x1 = xHalfLength * Math.cos(theta1);
        double y1 = yHalfLength * Math.sin(theta1);
        return BumpyBubble.getLength(x1 - x0, y1 - y0);
    }

    public String getMessage() {
        return this.m_message;
    }

    public void setMessage(String message) {
        this.m_message = message;
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public void initialize(Graphics2D g2) {
        MultilineText multilineText = new MultilineText(this.m_message, this.m_font, TextAlignment.LEADING, g2.getPaint());
        multilineText.setWrapWidth(400.0f);
        Rectangle2D bound = multilineText.getBounds(g2);
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ellipse.setFrame(bound);
        double xHalfBoxLength = ((RectangularShape)ellipse).getWidth() / 2.0;
        double yHalfBoxLength = ((RectangularShape)ellipse).getHeight() / 2.0;
        LinkedList<Bump> bumps = new LinkedList<Bump>();
        double thetaCurr = 0.0;
        double xUnit = 30.0;
        double yUnit = 30.0;
        while (thetaCurr < 6.233185307179586) {
            double xHalfEllipseLength = RandomUtilities.nextDoubleInRange(xUnit * 1.2, xUnit * 1.6);
            double yHalfEllipseLength = RandomUtilities.nextDoubleInRange(yUnit * 0.8, yUnit * 1.2);
            double THETA_STEP = 0.1;
            double thetaNext = thetaCurr;
            for (double s = 0.0; s < yHalfEllipseLength * 2.0; s += BumpyBubble.getDistanceBetween(thetaCurr, thetaNext += 0.1, xHalfBoxLength, yHalfBoxLength)) {
            }
            Bump bump = new Bump(xHalfEllipseLength, yHalfEllipseLength);
            double xOnBound = Math.cos(thetaCurr) * xHalfBoxLength;
            double yOnBound = Math.sin(thetaCurr) * yHalfBoxLength;
            bump.applyTranslation(xOnBound, yOnBound);
            bump.applyRotation(new AngleInRadians(thetaCurr));
            Color fillPaint = Color.WHITE;
            bump.setFillPaint(fillPaint);
            bumps.add(bump);
            thetaCurr = thetaNext;
        }
        Ellipse background = new Ellipse(xHalfBoxLength, yHalfBoxLength);
        background.setDrawn(false);
        background.setFilled(true);
        this.add(background);
        Point2D.Double ptSrc = new Point2D.Double();
        Point2D.Double ptDst = new Point2D.Double();
        int N_BUMPS = bumps.size();
        block2: for (int i = 0; i < N_BUMPS; ++i) {
            Bump prev = (Bump)bumps.get(i);
            Bump curr = (Bump)bumps.get((i + 1) % N_BUMPS);
            AffineTransform m = prev.getInverseAffineTransform();
            m.concatenate(curr.getAffineTransform());
            int N = BumpyBubble.s_sineCosineCache.cosines.length;
            for (int j = 0; j < N; ++j) {
                ptSrc.x = curr.getXHalfLength() * BumpyBubble.s_sineCosineCache.cosines[j];
                ptSrc.y = -curr.getYHalfLength() * BumpyBubble.s_sineCosineCache.sines[j];
                m.transform(ptSrc, ptDst);
                if (!prev.contains(ptDst)) continue;
                double angle0 = -1.5707963267948966;
                curr.setAnglesInDegrees(angle0, BumpyBubble.s_sineCosineCache.angles[j]);
                this.add(curr);
                continue block2;
            }
        }
        this.add(multilineText);
    }

    class Bump
    extends edu.cmu.cs.dennisc.awt.geom.Shape {
        private double m_xHalfLength;
        private double m_yHalfLength;
        private Ellipse2D.Double m_ellipse;
        private Arc2D.Double m_arc;

        public Bump(double xHalfLength, double yHalfLength) {
            this.m_ellipse = new Ellipse2D.Double(-xHalfLength, -yHalfLength, xHalfLength * 2.0, yHalfLength * 2.0);
            this.m_arc = new Arc2D.Double(-xHalfLength, -yHalfLength, xHalfLength * 2.0, yHalfLength * 2.0, -90.0, 180.0, 0);
            this.m_xHalfLength = xHalfLength;
            this.m_yHalfLength = yHalfLength;
        }

        public void setAngles(Angle angle0, Angle angle1) {
            this.setAnglesInDegrees(angle0.getAsDegrees(), angle1.getAsDegrees());
        }

        @Deprecated
        public void setAnglesInDegrees(double angle0, double angle1) {
            this.m_arc.setAngleStart(angle0);
            this.m_arc.setAngleExtent(-this.m_arc.getAngleStart() + angle1);
        }

        public double getXHalfLength() {
            return this.m_xHalfLength;
        }

        public double getYHalfLength() {
            return this.m_yHalfLength;
        }

        public boolean contains(Point2D.Double p) {
            return this.m_ellipse.contains(p);
        }

        protected Shape getDrawShape() {
            return this.m_arc;
        }

        protected Shape getFillShape() {
            return this.m_ellipse;
        }

        public String toString() {
            return "Bump[xHalfLength=" + this.m_xHalfLength + ";yHalfLength=" + this.m_yHalfLength + "]";
        }
    }
}

