/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl.graphics;

import edu.cmu.cs.dennisc.awt.MultilineText;
import edu.cmu.cs.dennisc.awt.geom.Ellipse;
import edu.cmu.cs.dennisc.awt.geom.GraphicsContext;
import edu.cmu.cs.dennisc.lookingglass.Graphics2D;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.opengl.graphics.BubbleAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.graphics.BumpyBubble;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.graphics.ThoughtBubble;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThoughtBubbleAdapter
extends BubbleAdapter<ThoughtBubble> {
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private Ellipse[] m_tailEllipses = null;
    private BumpyBubble m_bumpyBubble;
    private final int TAIL_ELLIPSE_COUNT = 3;
    private final double PORTION_PER_TAIL_ELLIPSE = 0.3333333333333333;

    private void paintEllipses(GraphicsContext gc, double portion) {
        for (int i = 0; i < this.m_tailEllipses.length; ++i) {
            double portion0 = (double)i * 0.3333333333333333;
            double portion1 = (double)(i + 1) * 0.3333333333333333;
            if (portion <= portion0) break;
            double desiredScale = portion > portion1 ? 1.0 : (portion - portion0) / 0.3333333333333333;
            AffineTransform affineTransform = this.m_tailEllipses[i].getAffineTransform();
            double currentScale = affineTransform.getScaleX();
            if (!(desiredScale > 0.0)) continue;
            double scaleFactor = desiredScale / currentScale;
            this.m_tailEllipses[i].applyScale(scaleFactor, scaleFactor);
            this.m_tailEllipses[i].paint(gc);
        }
    }

    @Override
    protected void render(Graphics2D g2, LookingGlass lookingGlass, Rectangle actualViewport, AbstractCamera camera, MultilineText multilineText, Font font, Color textColor, float wrapWidth, Color fillColor, Color outlineColor, Point2D.Float originOfTail, Point2D.Float bodyConnectionLocationOfTail, Point2D.Float textBoundsOffset, double portion) {
        Stroke stroke = g2.getStroke();
        g2.setStroke(STROKE);
        if (this.m_tailEllipses == null) {
            this.m_tailEllipses = new Ellipse[3];
            double xDelta = bodyConnectionLocationOfTail.getX() - originOfTail.getX();
            double yDelta = bodyConnectionLocationOfTail.getY() - originOfTail.getY();
            for (int i = 0; i < this.m_tailEllipses.length; ++i) {
                double factor = i + 1;
                this.m_tailEllipses[i] = new Ellipse(5.0 * factor, 3.0 * factor);
                this.m_tailEllipses[i].applyTranslation(originOfTail.getX() + (double)i * xDelta * 0.3333333333333333, originOfTail.getY() + (double)i * yDelta * 0.3333333333333333);
            }
        }
        GraphicsContext gc = new GraphicsContext();
        gc.initialize(g2);
        if (portion < 1.0) {
            this.paintEllipses(gc, portion);
        } else {
            if (this.m_bumpyBubble == null) {
                this.m_bumpyBubble = new BumpyBubble();
                this.m_bumpyBubble.setMessage(multilineText.getText());
                this.m_bumpyBubble.setFont(font);
                this.m_bumpyBubble.initialize(g2);
                this.m_bumpyBubble.applyTranslation(bodyConnectionLocationOfTail.getX() + textBoundsOffset.getX(), bodyConnectionLocationOfTail.getY() + textBoundsOffset.getY());
            }
            this.m_bumpyBubble.paint(gc);
            for (Ellipse tailEllipse : this.m_tailEllipses) {
                tailEllipse.paint(gc);
            }
        }
        g2.setStroke(stroke);
    }
}

