/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.util;

import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.util.SnapshotPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CardPane
extends JPanel {
    private SnapshotPane snapshotPane = new SnapshotPane();
    private OnscreenLookingGlass onscreenLookingGlass;
    public BufferedImage bufferedImage = null;
    private CardLayout cardLayout = new CardLayout();
    private static final String LIVE_KEY = "live";
    private static final String SNAPSHOT_KEY = "snapshot";
    private String currentKey = null;

    public CardPane(OnscreenLookingGlass onscreenLookingGlass, Component awtComponent) {
        this.setLayout(this.cardLayout);
        this.onscreenLookingGlass = onscreenLookingGlass;
        this.add(awtComponent, LIVE_KEY);
        this.add((Component)this.snapshotPane, SNAPSHOT_KEY);
        this.showLive();
    }

    public CardPane(OnscreenLookingGlass onscreenLookingGlass) {
        this(onscreenLookingGlass, onscreenLookingGlass.getAWTComponent());
    }

    private void showCard(String key) {
        this.cardLayout.show(this, key);
        this.currentKey = key;
    }

    public void showSnapshot() {
        if (this.isLive()) {
            int desiredImageWidth = this.onscreenLookingGlass.getWidth();
            int desiredImageHeight = this.onscreenLookingGlass.getHeight();
            if (this.bufferedImage != null && (this.bufferedImage.getWidth() != desiredImageWidth || this.bufferedImage.getHeight() != desiredImageHeight)) {
                this.bufferedImage = null;
            }
            if (this.bufferedImage == null && desiredImageWidth > 0 && desiredImageHeight > 0) {
                this.bufferedImage = this.onscreenLookingGlass.createBufferedImageForUseAsColorBuffer();
            }
            if (this.bufferedImage != null) {
                this.onscreenLookingGlass.getColorBuffer(this.bufferedImage);
                this.snapshotPane.setSnapshotImage(this.bufferedImage);
                this.showCard(SNAPSHOT_KEY);
                this.onscreenLookingGlass.setRenderingEnabled(false);
            }
        }
    }

    public void showLive() {
        if (!this.isLive()) {
            this.onscreenLookingGlass.setRenderingEnabled(true);
            this.showCard(LIVE_KEY);
        }
    }

    public boolean isLive() {
        return LIVE_KEY.equals(this.currentKey);
    }

    public void handleLiveChange() {
        if (!this.isLive()) {
            this.showLive();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CardPane.this.showSnapshot();
                }
            });
        }
    }
}

