/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;

public class AngleInDegrees
implements Angle {
    private double m_degrees;

    public AngleInDegrees(double degrees) {
        this.setAsDegrees(degrees);
    }

    public AngleInDegrees(Angle other) {
        this.set(other);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.m_degrees = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.m_degrees);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Angle) {
            Angle a = (Angle)obj;
            return this.m_degrees == a.getAsDegrees();
        }
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_degrees);
    }

    public void setNaN() {
        this.m_degrees = Double.NaN;
    }

    public double getAsRadians() {
        return AngleUtilities.degreesToRadians(this.m_degrees);
    }

    public double getAsDegrees() {
        return this.m_degrees;
    }

    public double getAsRevolutions() {
        return AngleUtilities.degreesToRevolutions(this.m_degrees);
    }

    public void setAsRadians(double radians) {
        this.m_degrees = AngleUtilities.radiansToDegrees(radians);
    }

    public void setAsDegrees(double degrees) {
        this.m_degrees = degrees;
    }

    public void setAsRevolutions(double revolutions) {
        this.m_degrees = AngleUtilities.revolutionsToDegrees(revolutions);
    }

    public Angle createCopy() {
        return new AngleInDegrees(this);
    }

    public void set(Angle other) {
        this.setAsDegrees(other.getAsDegrees());
    }

    public void setToInterpolation(Angle a0, Angle a1, double portion) {
        this.setAsDegrees(InterpolationUtilities.interpolate(a0.getAsDegrees(), a1.getAsDegrees(), portion));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(AngleInDegrees.class.getName());
        sb.append("[");
        sb.append(this.m_degrees);
        sb.append("]");
        return sb.toString();
    }
}

