/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;

public class AngleUtilities {
    public static final double REVOLUTIONS_TO_DEGREES_FACTOR = 360.0;
    public static final double REVOLUTIONS_TO_RADIANS_FACTOR = Math.PI * 2;
    public static final double DEGREES_TO_REVOLUTIONS_FACTOR = 0.002777777777777778;
    public static final double RADIANS_TO_REVOLUTIONS_FACTOR = 0.15915494309189535;
    public static final double RADIANS_TO_DEGREES_FACTOR = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS_FACTOR = Math.PI / 180;

    public static double radiansToRevolutions(double radians) {
        return radians * 0.15915494309189535;
    }

    public static double radiansToDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static double degreesToRevolutions(double degrees) {
        return degrees * 0.002777777777777778;
    }

    public static double degreesToRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double revolutionsToRadians(double revolutions) {
        return revolutions * (Math.PI * 2);
    }

    public static double revolutionsToDegrees(double revolutions) {
        return revolutions * 360.0;
    }

    public static Angle createNaN() {
        return new AngleInRadians(Double.NaN);
    }

    public static Angle createAddition(Angle a, Angle b) {
        return AngleUtilities.setReturnValueToAddition(AngleUtilities.createNaN(), a, b);
    }

    public static Angle createSubtraction(Angle a, Angle b) {
        return AngleUtilities.setReturnValueToSubtraction(AngleUtilities.createNaN(), a, b);
    }

    public static Angle createNegation(Angle a) {
        return AngleUtilities.setReturnValueToNegation(AngleUtilities.createNaN(), a);
    }

    public static Angle createInterpolation(Angle a, Angle b, double portion) {
        return AngleUtilities.setReturnValueToInterpolation(AngleUtilities.createNaN(), a, b, portion);
    }

    public static Angle setReturnValueToAddition(Angle rv, Angle a, Angle b) {
        rv.setAsRadians(a.getAsRadians() + b.getAsRadians());
        return rv;
    }

    public static Angle setReturnValueToSubtraction(Angle rv, Angle a, Angle b) {
        rv.setAsRadians(a.getAsRadians() - b.getAsRadians());
        return rv;
    }

    public static Angle setReturnValueToNegation(Angle rv, Angle a) {
        rv.setAsRadians(-a.getAsRadians());
        return rv;
    }

    public static Angle setReturnValueToInterpolation(Angle rv, Angle a, Angle b, double portion) {
        double aInRadians = a.getAsRadians();
        double bInRadians = b.getAsRadians();
        rv.setAsRadians(aInRadians + (bInRadians - aInRadians) * portion);
        return rv;
    }
}

