/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.Frustum;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import java.io.Serializable;

public class ClippedPlane
implements Serializable {
    private Point3[] m_points = new Point3[]{new Point3(), new Point3(), new Point3(), new Point3()};
    private Vector3 m_normal = new Vector3();

    public ClippedPlane() {
        this.setNaN();
    }

    public ClippedPlane(Point3[] points, Vector3 normal) {
        this.set(points, normal);
    }

    public ClippedPlane(ClippedPlane other) {
        this.set(other);
    }

    private boolean isEqual(ClippedPlane other) {
        for (int i = 0; i < this.m_points.length; ++i) {
            if (this.m_points[i].equals(other.m_points[i])) continue;
            return false;
        }
        return this.m_normal.equals(other.m_normal);
        {
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Frustum) {
            return this.isEqual((ClippedPlane)other);
        }
        return false;
    }

    public void set(Point3[] points, Vector3 normal) {
        for (int i = 0; i < this.m_points.length; ++i) {
            this.m_points[i].set(points[i]);
        }
        this.m_normal.set(normal);
    }

    public void set(ClippedPlane other) {
        if (other != null) {
            this.set(other.m_points, other.m_normal);
        } else {
            this.setNaN();
        }
    }

    public void setNaN() {
        for (Point3 point : this.m_points) {
            point.setNaN();
        }
        this.m_normal.setNaN();
    }

    public boolean isNaN() {
        for (Point3 point : this.m_points) {
            if (!point.isNaN()) continue;
            return true;
        }
        return this.m_normal.isNaN();
    }

    public void transform(AbstractMatrix4x4 m) {
        for (Point3 point : this.m_points) {
            m.transform(point);
        }
        m.transform(this.m_normal);
    }

    public Plane getPlane(Plane rv) {
        rv.set(this.m_points[0], this.m_normal);
        return rv;
    }

    public Plane getPlane() {
        return this.getPlane(new Plane());
    }
}

