/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

public class EpsilonUtilities {
    public static final double REASONABLE_EPSILON = 0.001;
    public static final double MINIMUM_FOR_WITHIN_REASONABLE_EPSILON_OF_1_IN_SQUARED_SPACE = 0.998001;
    public static final double MAXIMUM_FOR_WITHIN_REASONABLE_EPSILON_OF_1_IN_SQUARED_SPACE = 1.0020009999999997;
    public static final double MAXIMUM_FOR_WITHIN_REASONABLE_EPSILON_OF_0_IN_SQUARED_SPACE = 1.0E-6;
    public static final float REASONABLE_EPSILON_FLOAT = 0.001f;
    public static final float MINIMUM_FOR_WITHIN_REASONABLE_EPSILON_OF_1_IN_SQUARED_SPACE_FLOAT = 0.998001f;
    public static final float MAXIMUM_FOR_WITHIN_REASONABLE_EPSILON_OF_1_IN_SQUARED_SPACE_FLOAT = 1.002001f;
    public static final float MAXIMUM_FOR_WITHIN_REASONABLE_EPSILON_OF_0_IN_SQUARED_SPACE_FLOAT = 1.0E-6f;

    public static boolean isWithinEpsilon(Number a, double b, double epsilon) {
        return Math.abs(a.doubleValue() - b) < epsilon;
    }

    public static boolean isWithinEpsilon(Number a, float b, float epsilon) {
        return Math.abs(a.floatValue() - b) < epsilon;
    }

    public static boolean isWithinReasonableEpsilon(Number a, double b) {
        return EpsilonUtilities.isWithinEpsilon(a, b, 0.001);
    }

    public static boolean isWithinReasonableEpsilon(Number a, float b) {
        return EpsilonUtilities.isWithinEpsilon(a, b, 0.001f);
    }

    public static boolean isWithinEpsilonOf1InSquaredSpace(double a, double epsilon) {
        double min = 1.0 - epsilon;
        double max = 1.0 + epsilon;
        return min * min < a && a < max * max;
    }

    public static boolean isWithinEpsilonOf0InSquaredSpace(double a, double epsilon) {
        return a < epsilon * epsilon;
    }

    public static boolean isWithinEpsilonOf1InSquaredSpace(float a, float epsilon) {
        float min = 1.0f - epsilon;
        float max = 1.0f + epsilon;
        return min * min < a && a < max * max;
    }

    public static boolean isWithinEpsilonOf0InSquaredSpace(float a, float epsilon) {
        return a < epsilon * epsilon;
    }

    public static boolean isWithinReasonableEpsilonOf1InSquaredSpace(double a) {
        return 0.998001 < a && a < 1.0E-6;
    }

    public static boolean isWithinReasonableEpsilonOf0InSquaredSpace(double a) {
        return a < 1.0E-6;
    }

    public static boolean isWithinReasonableEpsilonOf1InSquaredSpace(float a) {
        return 0.998001f < a && a < 1.0E-6f;
    }

    public static boolean isWithinReasonableEpsilonOf0InSquaredSpace(float a) {
        return a < 1.0E-6f;
    }
}

