/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.AbstractMatrix3x3;
import edu.cmu.cs.dennisc.math.Vector3;

public final class Matrix3x3
extends AbstractMatrix3x3 {
    private static final Matrix3x3 IDENTITY = new Matrix3x3();

    public static Matrix3x3 accessIdentity() {
        IDENTITY.setIdentity();
        return IDENTITY;
    }

    public Matrix3x3() {
        this.setIdentity();
    }

    public Matrix3x3(Vector3 right, Vector3 up, Vector3 backward) {
        this.set(right, up, backward);
    }

    @Deprecated
    public Matrix3x3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public Matrix3x3(AbstractMatrix3x3 other) {
        this.setValue(other);
    }

    public void setValue(AbstractMatrix3x3 other) {
        super.setValue(other);
    }

    public static Matrix3x3 createNaN() {
        return (Matrix3x3)Matrix3x3.setReturnValueToNaN(new Matrix3x3());
    }

    public static Matrix3x3 createIdentity() {
        return (Matrix3x3)Matrix3x3.setReturnValueToIdentity(Matrix3x3.createNaN());
    }

    public static Matrix3x3 setReturnValueToZero(Matrix3x3 rv) {
        rv.right.setZero();
        rv.up.setZero();
        rv.backward.setZero();
        return rv;
    }

    public static Matrix3x3 createZero() {
        return Matrix3x3.setReturnValueToZero(Matrix3x3.createNaN());
    }

    public void setZero() {
        Matrix3x3.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.right.isZero() && this.up.isZero() && this.backward.isZero();
    }

    @Deprecated
    public void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.right.x = m00;
        this.up.x = m01;
        this.backward.x = m02;
        this.right.y = m10;
        this.up.y = m11;
        this.backward.y = m12;
        this.right.z = m20;
        this.up.z = m21;
        this.backward.z = m22;
    }
}

