/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.math.AbstractMatrix3x3;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRevolutions;
import edu.cmu.cs.dennisc.math.AxisRotation;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.EulerAngles;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;

public final class OrthogonalMatrix3x3
extends AbstractMatrix3x3
implements Orientation,
BinaryEncodableAndDecodable {
    private static final OrthogonalMatrix3x3 IDENTITY = new OrthogonalMatrix3x3();

    public static OrthogonalMatrix3x3 accessIdentity() {
        IDENTITY.setIdentity();
        return IDENTITY;
    }

    public OrthogonalMatrix3x3() {
        this.setIdentity();
    }

    public OrthogonalMatrix3x3(OrthogonalMatrix3x3 other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3(UnitQuaternion other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3(AxisRotation other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3(EulerAngles other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3(ForwardAndUpGuide other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3(Vector3 right, Vector3 up, Vector3 backward) {
        this.set(right, up, backward);
    }

    public OrthogonalMatrix3x3 createOrthogonalMatrix3x3() {
        return new OrthogonalMatrix3x3(this);
    }

    public UnitQuaternion createUnitQuaternion() {
        return new UnitQuaternion(this);
    }

    public AxisRotation createAxisRotation() {
        return new AxisRotation(this);
    }

    public EulerAngles createEulerAngles() {
        return new EulerAngles(this);
    }

    public ForwardAndUpGuide createForwardAndUpGuide() {
        return new ForwardAndUpGuide(this);
    }

    public OrthogonalMatrix3x3 getValue(OrthogonalMatrix3x3 rv) {
        rv.setValue(this);
        return rv;
    }

    public UnitQuaternion getValue(UnitQuaternion rv) {
        rv.setValue(this);
        return rv;
    }

    public AxisRotation getValue(AxisRotation rv) {
        rv.setValue(this);
        return rv;
    }

    public EulerAngles getValue(EulerAngles rv) {
        rv.setValue(this);
        return rv;
    }

    public ForwardAndUpGuide getValue(ForwardAndUpGuide rv) {
        rv.setValue(this);
        return rv;
    }

    public void setValue(OrthogonalMatrix3x3 other) {
        super.setValue(other);
    }

    public void setValue(UnitQuaternion q) {
        double wx = q.w * q.x;
        double wy = q.w * q.y;
        double wz = q.w * q.z;
        double xx = q.x * q.x;
        double xy = q.x * q.y;
        double xz = q.x * q.z;
        double yy = q.y * q.y;
        double yz = q.y * q.z;
        double zz = q.z * q.z;
        this.right.x = 1.0 - 2.0 * (yy + zz);
        this.up.x = 2.0 * (xy - wz);
        this.backward.x = 2.0 * (xz + wy);
        this.right.y = 2.0 * (xy + wz);
        this.up.y = 1.0 - 2.0 * (xx + zz);
        this.backward.y = 2.0 * (yz - wx);
        this.right.z = 2.0 * (xz - wy);
        this.up.z = 2.0 * (yz + wx);
        this.backward.z = 1.0 - 2.0 * (xx + yy);
    }

    public void setValue(AxisRotation aa) {
        double thetaInRadians = aa.angle.getAsRadians();
        double c = Math.cos(thetaInRadians);
        double s = Math.sin(thetaInRadians);
        double t = 1.0 - c;
        this.right.x = c + aa.axis.x * aa.axis.x * t;
        this.up.y = c + aa.axis.y * aa.axis.y * t;
        this.backward.z = c + aa.axis.z * aa.axis.z * t;
        double xyt = aa.axis.x * aa.axis.y * t;
        double zs = aa.axis.z * s;
        this.right.y = xyt + zs;
        this.up.x = xyt - zs;
        double xzt = aa.axis.x * aa.axis.z * t;
        double ys = aa.axis.y * s;
        this.right.z = xzt - ys;
        this.backward.x = xzt + ys;
        double yzt = aa.axis.y * aa.axis.z * t;
        double xs = aa.axis.x * s;
        this.up.z = yzt + xs;
        this.backward.y = yzt - xs;
    }

    public void setValue(EulerAngles ea) {
        assert (ea.order != null);
        if (ea.order == EulerAngles.Order.YAW_PITCH_ROLL) {
            double theta = ea.yaw.getAsRadians();
            double phi = ea.pitch.getAsRadians();
            double psi = ea.roll.getAsRadians();
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double cosPhi = Math.cos(phi);
            double sinPhi = Math.sin(phi);
            double cosPsi = Math.cos(psi);
            double sinPsi = Math.sin(psi);
            this.right.x = cosPsi * cosTheta;
            this.up.x = cosPsi * sinTheta * sinPhi - sinPsi * cosPhi;
            this.backward.x = cosPsi * sinTheta * cosPhi + sinPsi * sinPhi;
            this.right.y = sinPsi * cosTheta;
            this.up.y = sinPsi * sinTheta * sinPhi + cosPsi * cosPhi;
            this.backward.y = sinPsi * sinTheta * cosPhi - cosPsi * sinPhi;
            this.right.z = -sinTheta;
            this.up.z = cosTheta * sinPhi;
            this.backward.z = cosTheta * cosPhi;
        } else {
            ea.order.setReturnValueToPitchYawRoll(this, ea.pitch, ea.yaw, ea.roll);
        }
    }

    public void setValue(ForwardAndUpGuide faug) {
        assert (!faug.forward.isNaN());
        if (faug.forward.calculateMagnitudeSquared() == 0.0) {
            this.setNaN();
        } else {
            Vector3 upGuide = !faug.upGuide.isNaN() ? faug.upGuide : (faug.forward.x == 0.0 && faug.forward.z == 0.0 ? Vector3.accessPositiveXAxis() : Vector3.accessPositiveYAxis());
            assert (!upGuide.isNaN());
            Vector3 xAxis = new Vector3();
            Vector3 yAxis = new Vector3();
            Vector3 zAxis = new Vector3();
            zAxis.set(faug.forward);
            zAxis.negate();
            zAxis.normalize();
            yAxis.set(upGuide);
            yAxis.normalize();
            Vector3.setReturnValueToCrossProduct(xAxis, yAxis, zAxis);
            Vector3.setReturnValueToCrossProduct(yAxis, zAxis, xAxis);
            xAxis.normalize();
            yAxis.normalize();
            this.right.set(xAxis);
            this.up.set(yAxis);
            this.backward.set(zAxis);
            assert (this.isWithinReasonableEpsilonOfUnitLengthSquared());
            assert (!this.isNaN());
        }
    }

    public static OrthogonalMatrix3x3 createNaN() {
        return (OrthogonalMatrix3x3)OrthogonalMatrix3x3.setReturnValueToNaN(new OrthogonalMatrix3x3());
    }

    public static OrthogonalMatrix3x3 createIdentity() {
        return (OrthogonalMatrix3x3)OrthogonalMatrix3x3.setReturnValueToIdentity(OrthogonalMatrix3x3.createNaN());
    }

    public static OrthogonalMatrix3x3 createFromRotationAboutXAxis(Angle angle) {
        OrthogonalMatrix3x3 rv = new OrthogonalMatrix3x3();
        rv.setToRotationAboutXAxis(angle);
        return rv;
    }

    public static OrthogonalMatrix3x3 createFromRotationAboutYAxis(Angle angle) {
        OrthogonalMatrix3x3 rv = new OrthogonalMatrix3x3();
        rv.setToRotationAboutYAxis(angle);
        return rv;
    }

    public static OrthogonalMatrix3x3 createFromRotationAboutZAxis(Angle angle) {
        OrthogonalMatrix3x3 rv = new OrthogonalMatrix3x3();
        rv.setToRotationAboutZAxis(angle);
        return rv;
    }

    public static OrthogonalMatrix3x3 createFromForwardAndUpGuide(Vector3 forward, Vector3 upGuide) {
        return new OrthogonalMatrix3x3(new ForwardAndUpGuide(forward, upGuide));
    }

    public static OrthogonalMatrix3x3 setReturnValueToRotationAboutArbitraryAxis(OrthogonalMatrix3x3 rv, Vector3 axis, Angle angle) {
        double angleInRadians = angle.getAsRadians();
        double c = Math.cos(angleInRadians);
        double s = Math.sin(angleInRadians);
        double t = 1.0 - c;
        double w = axis.calculateMagnitude();
        assert (w > 0.0);
        double x = axis.x / w;
        double y = axis.y / w;
        double z = axis.z / w;
        rv.right.set(t * x * x + c, t * x * y + s * z, t * x * z - s * y);
        rv.up.set(t * x * y - s * z, t * y * y + c, t * y * z + s * x);
        rv.backward.set(t * x * z + s * y, t * y * z - s * x, t * z * z + c);
        return rv;
    }

    public void setToRotationAboutArbitraryAxis(Vector3 axis, Angle angle) {
        OrthogonalMatrix3x3.setReturnValueToRotationAboutArbitraryAxis(this, axis, angle);
    }

    public static OrthogonalMatrix3x3 createRotationAboutArbitraryAxis(Vector3 axis, Angle angle) {
        return OrthogonalMatrix3x3.setReturnValueToRotationAboutArbitraryAxis(new OrthogonalMatrix3x3(), axis, angle);
    }

    public static OrthogonalMatrix3x3 setReturnValueToNormalizedColumns(OrthogonalMatrix3x3 rv, AbstractMatrix3x3 m) {
        if (rv != m) {
            rv.right.set(m.right);
            rv.up.set(m.right);
            rv.backward.set(m.right);
        }
        rv.right.normalize();
        rv.up.normalize();
        rv.backward.normalize();
        return rv;
    }

    public static OrthogonalMatrix3x3 createNormalizedColumns(AbstractMatrix3x3 m) {
        return OrthogonalMatrix3x3.setReturnValueToNormalizedColumns(new OrthogonalMatrix3x3(), m);
    }

    public void setToNormalizedColumns(AbstractMatrix3x3 m) {
        OrthogonalMatrix3x3.setReturnValueToNormalizedColumns(this, m);
    }

    public void normalizeColumns() {
        this.setToNormalizedColumns(this);
    }

    public static OrthogonalMatrix3x3 setReturnValueToStandUp(OrthogonalMatrix3x3 rv, OrthogonalMatrix3x3 m) {
        Vector3 zAxis = new Vector3(m.backward);
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)m.up.y, 1.0)) {
            rv.setValue(m);
        } else if (EpsilonUtilities.isWithinReasonableEpsilon((Number)zAxis.x, 0.0f) && EpsilonUtilities.isWithinReasonableEpsilon((Number)zAxis.z, 0.0f)) {
            rv.setValue(m);
            double theta = zAxis.y < 0.0 ? -0.25 : 0.25;
            rv.applyRotationAboutXAxis(new AngleInRevolutions(theta));
        } else {
            if (!EpsilonUtilities.isWithinReasonableEpsilon((Number)zAxis.y, 0.0)) {
                zAxis.y = 0.0;
                zAxis.normalize();
            }
            Vector3 yAxis = Vector3.accessPositiveYAxis();
            Vector3 xAxis = Vector3.createCrossProduct(yAxis, zAxis);
            rv.right.set(xAxis);
            rv.up.set(yAxis);
            rv.backward.set(zAxis);
        }
        return rv;
    }

    public static OrthogonalMatrix3x3 createFromStandUp(OrthogonalMatrix3x3 m) {
        return OrthogonalMatrix3x3.setReturnValueToStandUp(new OrthogonalMatrix3x3(), m);
    }

    public void setToMultiplication(OrthogonalMatrix3x3 a, OrthogonalMatrix3x3 b) {
        super.setToMultiplication(a, b);
    }

    public void applyMultiplication(OrthogonalMatrix3x3 b) {
        super.applyMultiplication(b);
    }

    public void applyRotationAboutXAxis(Angle theta) {
        OrthogonalMatrix3x3 other = new OrthogonalMatrix3x3();
        other.setToRotationAboutXAxis(theta);
        this.applyMultiplication(other);
    }

    public void applyRotationAboutYAxis(Angle theta) {
        OrthogonalMatrix3x3 other = new OrthogonalMatrix3x3();
        other.setToRotationAboutYAxis(theta);
        this.applyMultiplication(other);
    }

    public void applyRotationAboutZAxis(Angle theta) {
        OrthogonalMatrix3x3 other = new OrthogonalMatrix3x3();
        other.setToRotationAboutZAxis(theta);
        this.applyMultiplication(other);
    }

    public void applyRotationAboutArbitraryAxis(Vector3 axis, Angle theta) {
        OrthogonalMatrix3x3 other = new OrthogonalMatrix3x3();
        other.setToRotationAboutArbitraryAxis(axis, theta);
        this.applyMultiplication(other);
    }

    public void setToRotationAboutXAxis(Angle theta) {
        double thetaInRadians = theta.getAsRadians();
        double s = Math.sin(thetaInRadians);
        double c = Math.cos(thetaInRadians);
        this.right.x = 1.0;
        this.up.x = 0.0;
        this.backward.x = 0.0;
        this.right.y = 0.0;
        this.up.y = c;
        this.backward.y = -s;
        this.right.z = 0.0;
        this.up.z = s;
        this.backward.z = c;
    }

    public void setToRotationAboutYAxis(Angle theta) {
        double c;
        double thetaInRadians = theta.getAsRadians();
        double s = Math.sin(thetaInRadians);
        this.right.x = c = Math.cos(thetaInRadians);
        this.up.x = 0.0;
        this.backward.x = s;
        this.right.y = 0.0;
        this.up.y = 1.0;
        this.backward.y = 0.0;
        this.right.z = -s;
        this.up.z = 0.0;
        this.backward.z = c;
    }

    public void setToRotationAboutZAxis(Angle theta) {
        double c;
        double thetaInRadians = theta.getAsRadians();
        double s = Math.sin(thetaInRadians);
        this.right.x = c = Math.cos(thetaInRadians);
        this.up.x = -s;
        this.backward.x = 0.0;
        this.right.y = s;
        this.up.y = c;
        this.backward.y = 0.0;
        this.right.z = 0.0;
        this.up.z = 0.0;
        this.backward.z = 1.0;
    }
}

