/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector4;

public final class Point3
extends Tuple3 {
    public Point3() {
    }

    public Point3(Tuple3 other) {
        super(other);
    }

    public Point3(double x, double y, double z) {
        super(x, y, z);
    }

    public static Point3 createZero() {
        return (Point3)Point3.setReturnValueToZero(new Point3());
    }

    public static Point3 createNaN() {
        return (Point3)Point3.setReturnValueToNaN(new Point3());
    }

    public static Point3 createAddition(Tuple3 a, Tuple3 b) {
        return (Point3)Point3.setReturnValueToAddition(new Point3(), a, b);
    }

    public static Point3 createSubtraction(Tuple3 a, Tuple3 b) {
        return (Point3)Point3.setReturnValueToSubtraction(new Point3(), a, b);
    }

    public static Point3 createNegation(Tuple3 a) {
        return (Point3)Point3.setReturnValueToNegation(new Point3(), a);
    }

    public static Point3 createMultiplication(Tuple3 a, Tuple3 b) {
        return (Point3)Point3.setReturnValueToMultiplication((Tuple3)new Point3(), a, b);
    }

    public static Point3 createMultiplication(Tuple3 a, double b) {
        return (Point3)Point3.setReturnValueToMultiplication((Tuple3)new Point3(), a, b);
    }

    public static Point3 createDivision(Tuple3 a, Tuple3 b) {
        return (Point3)Point3.setReturnValueToDivision((Tuple3)new Point3(), a, b);
    }

    public static Point3 createDivision(Tuple3 a, double b) {
        return (Point3)Point3.setReturnValueToDivision((Tuple3)new Point3(), a, b);
    }

    public static Point3 createInterpolation(Tuple3 a, Tuple3 b, double portion) {
        return (Point3)Point3.setReturnValueToInterpolation(new Point3(), a, b, portion);
    }

    public static Point3 createNormalized(Tuple3 a) {
        return (Point3)Point3.setReturnValueToNormalized(new Point3(), a);
    }

    public static Point3 createFromXYZW(Vector4 xyzw) {
        return new Point3(xyzw.x / xyzw.w, xyzw.y / xyzw.w, xyzw.z / xyzw.w);
    }

    public void setToTranslationComponentOf(Matrix4x4 m) {
        this.x = m.translation.x;
        this.y = m.translation.y;
        this.z = m.translation.z;
    }

    public static double calculateDistanceSquaredBetween(Point3 a, Point3 b) {
        double xDelta = b.x - a.x;
        double yDelta = b.y - a.y;
        double zDelta = b.z - a.z;
        return xDelta * xDelta + yDelta * yDelta + zDelta * zDelta;
    }

    public static double calculateDistanceBetween(Point3 a, Point3 b) {
        return Math.sqrt(Point3.calculateDistanceSquaredBetween(a, b));
    }
}

