/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.Tuple3f;
import edu.cmu.cs.dennisc.math.Vector4f;

public final class Point3f
extends Tuple3f {
    public Point3f() {
    }

    public Point3f(Tuple3f other) {
        super(other);
    }

    public Point3f(float x, float y, float z) {
        super(x, y, z);
    }

    public static Point3f createZero() {
        return (Point3f)Point3f.setReturnValueToZero(new Point3f());
    }

    public static Point3f createNaN() {
        return (Point3f)Point3f.setReturnValueToNaN(new Point3f());
    }

    public static Point3f createAddition(Tuple3f a, Tuple3f b) {
        return (Point3f)Point3f.setReturnValueToAddition(new Point3f(), a, b);
    }

    public static Point3f createSubtraction(Tuple3f a, Tuple3f b) {
        return (Point3f)Point3f.setReturnValueToSubtraction(new Point3f(), a, b);
    }

    public static Point3f createNegation(Tuple3f a) {
        return (Point3f)Point3f.setReturnValueToNegation(new Point3f(), a);
    }

    public static Point3f createMultiplication(Tuple3f a, Tuple3f b) {
        return (Point3f)Point3f.setReturnValueToMultiplication((Tuple3f)new Point3f(), a, b);
    }

    public static Point3f createMultiplication(Tuple3f a, float b) {
        return (Point3f)Point3f.setReturnValueToMultiplication((Tuple3f)new Point3f(), a, b);
    }

    public static Point3f createDivision(Tuple3f a, Tuple3f b) {
        return (Point3f)Point3f.setReturnValueToDivision((Tuple3f)new Point3f(), a, b);
    }

    public static Point3f createDivision(Tuple3f a, float b) {
        return (Point3f)Point3f.setReturnValueToDivision((Tuple3f)new Point3f(), a, b);
    }

    public static Point3f createInterpolation(Tuple3f a, Tuple3f b, float portion) {
        return (Point3f)Point3f.setReturnValueToInterpolation(new Point3f(), a, b, portion);
    }

    public static Point3f createNormalized(Tuple3f a) {
        return (Point3f)Point3f.setReturnValueToNormalized(new Point3f(), a);
    }

    public static Point3f createFromXYZW(Vector4f xyzw) {
        return new Point3f(xyzw.x / xyzw.w, xyzw.y / xyzw.w, xyzw.z / xyzw.w);
    }

    public static float calculateDistanceSquaredBetween(Point3f a, Point3f b) {
        float xDelta = b.x - a.x;
        float yDelta = b.y - a.y;
        float zDelta = b.z - a.z;
        return xDelta * xDelta + yDelta * yDelta + zDelta * zDelta;
    }

    public static float calculateDistanceBetween(Point3f a, Point3f b) {
        return (float)Math.sqrt(Point3f.calculateDistanceSquaredBetween(a, b));
    }
}

