/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import java.io.Serializable;

public class Ray
implements Serializable {
    protected Point3 m_origin = new Point3(0.0, 0.0, 0.0);
    protected Vector3 m_direction = new Vector3(0.0, 0.0, 1.0);

    public Ray() {
    }

    public Ray(Point3 origin, Vector3 direction) {
        this.m_origin.set(origin);
        this.m_direction.set(direction);
    }

    public Ray(Ray other) {
        this.m_origin = other.getOrigin();
        this.m_direction = other.getDirection();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Ray) {
            Ray ray = (Ray)o;
            return this.m_origin.equals(ray.m_origin) && this.m_direction.equals(ray.m_direction);
        }
        return false;
    }

    public boolean isNaN() {
        return this.m_origin.isNaN() || this.m_direction.isNaN();
    }

    public void setNaN() {
        this.m_origin.setNaN();
        this.m_direction.setNaN();
    }

    public Point3 accessOrigin() {
        return this.m_origin;
    }

    public Point3 getOrigin(Point3 rv) {
        rv.set(this.m_origin);
        return rv;
    }

    public Point3 getOrigin() {
        return this.getOrigin(new Point3());
    }

    public void setOrigin(Point3 origin) {
        if (origin != null) {
            this.m_origin.set(origin);
        } else {
            this.m_origin.set(Double.NaN, Double.NaN, Double.NaN);
        }
    }

    public Vector3 accessDirection() {
        return this.m_direction;
    }

    public Vector3 getDirection(Vector3 rv) {
        rv.set(this.m_direction);
        return rv;
    }

    public Vector3 getDirection() {
        return this.getDirection(new Vector3());
    }

    public void setDirection(Vector3 direction) {
        if (direction != null) {
            this.m_direction.set(direction);
        } else {
            this.m_direction.set(Double.NaN, Double.NaN, Double.NaN);
        }
    }

    public Point3 getPointAlong(Point3 rv, double t) {
        rv.set(this.m_direction);
        rv.multiply(t);
        rv.add(this.m_origin);
        return rv;
    }

    public Point3 getPointAlong(double t) {
        return this.getPointAlong(new Point3(), t);
    }

    public void transform(AffineMatrix4x4 m) {
        m.transform(this.m_origin);
        m.transform(this.m_direction);
    }

    public String toString() {
        return "edu.cmu.cs.dennisc.math.Ray[origin=" + this.m_origin + ",direction=" + this.m_direction + "]";
    }
}

