/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Tuple3;

public class ScaleUtilities {
    public static Matrix3x3 set_AffectScaleXOnly(Matrix3x3 rv, double x) {
        rv.right.x = x;
        return rv;
    }

    public static Matrix3x3 set_AffectScaleYOnly(Matrix3x3 rv, double y) {
        rv.up.y = y;
        return rv;
    }

    public static Matrix3x3 set_AffectScaleZOnly(Matrix3x3 rv, double z) {
        rv.backward.z = z;
        return rv;
    }

    public static Matrix3x3 set_AffectScaleOnly(Matrix3x3 rv, double x, double y, double z) {
        ScaleUtilities.set_AffectScaleXOnly(rv, x);
        ScaleUtilities.set_AffectScaleYOnly(rv, y);
        ScaleUtilities.set_AffectScaleZOnly(rv, z);
        return rv;
    }

    public static Matrix3x3 set_AffectScaleOnly(Matrix3x3 rv, Tuple3 t) {
        return ScaleUtilities.set_AffectScaleOnly(rv, t.x, t.y, t.z);
    }

    public static Matrix3x3 newScaleMatrix3d(Matrix3x3 rv, double x, double y, double z) {
        rv.right.set(x, 0.0, 0.0);
        rv.up.set(0.0, y, 0.0);
        rv.backward.set(0.0, 0.0, z);
        return rv;
    }

    public static Matrix3x3 newScaleMatrix3d(double x, double y, double z) {
        return ScaleUtilities.newScaleMatrix3d(Matrix3x3.createNaN(), x, y, z);
    }

    public static Matrix3x3 newScaleMatrix3d(Matrix3x3 rv, Tuple3 t) {
        return ScaleUtilities.newScaleMatrix3d(rv, t.x, t.y, t.z);
    }

    public static Matrix3x3 newScaleMatrix3d(Tuple3 t) {
        return ScaleUtilities.newScaleMatrix3d(Matrix3x3.createNaN(), t);
    }

    public static Matrix3x3 applyScale(Matrix3x3 rv, double x, double y, double z) {
        rv.applyMultiplication(ScaleUtilities.newScaleMatrix3d(x, y, z));
        return rv;
    }

    public static Matrix3x3 applyScale(Matrix3x3 rv, Tuple3 t) {
        return ScaleUtilities.applyScale(rv, t.x, t.y, t.z);
    }

    public static Matrix4x4 set_AffectScaleXOnly(Matrix4x4 rv, double x) {
        rv.right.x = x;
        return rv;
    }

    public static Matrix4x4 set_AffectScaleYOnly(Matrix4x4 rv, double y) {
        rv.up.y = y;
        return rv;
    }

    public static Matrix4x4 set_AffectScaleZOnly(Matrix4x4 rv, double z) {
        rv.backward.z = z;
        return rv;
    }

    public static Matrix4x4 set_AffectScaleOnly(Matrix4x4 rv, double x, double y, double z) {
        ScaleUtilities.set_AffectScaleXOnly(rv, x);
        ScaleUtilities.set_AffectScaleYOnly(rv, y);
        ScaleUtilities.set_AffectScaleZOnly(rv, z);
        return rv;
    }

    public static Matrix4x4 set_AffectScaleOnly(Matrix4x4 rv, Tuple3 t) {
        return ScaleUtilities.set_AffectScaleOnly(rv, t.x, t.y, t.z);
    }

    public static Matrix4x4 newScaleMatrix4d(Matrix4x4 rv, double x, double y, double z) {
        rv.right.x = x;
        rv.up.x = 0.0;
        rv.backward.x = 0.0;
        rv.translation.x = 0.0;
        rv.right.y = 0.0;
        rv.up.y = y;
        rv.backward.y = 0.0;
        rv.translation.y = 0.0;
        rv.right.z = 0.0;
        rv.up.z = 0.0;
        rv.backward.z = z;
        rv.translation.z = 0.0;
        rv.right.w = 0.0;
        rv.up.w = 0.0;
        rv.backward.w = 0.0;
        rv.translation.w = 1.0;
        return rv;
    }

    public static Matrix4x4 newScaleMatrix4d(double x, double y, double z) {
        return ScaleUtilities.newScaleMatrix4d(new Matrix4x4(), x, y, z);
    }

    public static Matrix4x4 newScaleMatrix4d(Matrix4x4 rv, Tuple3 t) {
        return ScaleUtilities.newScaleMatrix4d(rv, t.x, t.y, t.z);
    }

    public static Matrix4x4 newScaleMatrix4d(Tuple3 t) {
        return ScaleUtilities.newScaleMatrix4d(new Matrix4x4(), t);
    }

    public static Matrix4x4 applyScale(Matrix4x4 rv, double x, double y, double z) {
        rv.applyMultiplication(ScaleUtilities.newScaleMatrix4d(x, y, z));
        return rv;
    }

    public static Matrix4x4 applyScale(Matrix4x4 rv, Tuple3 t) {
        return ScaleUtilities.applyScale(rv, t.x, t.y, t.z);
    }
}

