/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;

public class Sphere
implements BinaryEncodableAndDecodable {
    public final Point3 center = Point3.createNaN();
    public double radius = Double.NaN;

    public Sphere() {
        this.setNaN();
    }

    public Sphere(Point3 center, double radius) {
        this.center.set(center);
        this.radius = radius;
    }

    public Sphere(Sphere other) {
        this.set(other);
    }

    public Sphere(BinaryDecoder binaryDecoder) {
        this.decode(binaryDecoder);
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.center);
        binaryEncoder.encode(this.radius);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        binaryDecoder.decodeBinaryEncodableAndDecodable(this.center);
        this.radius = binaryDecoder.decodeDouble();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Sphere) {
            Sphere s = (Sphere)o;
            if (this.isNaN()) {
                return s.isNaN();
            }
            return this.center.equals(s.center) && this.radius == s.radius;
        }
        return false;
    }

    public void setNaN() {
        this.center.setNaN();
        this.radius = Double.NaN;
    }

    public void set(Sphere other) {
        if (other != null) {
            this.center.set(other.center);
            this.radius = other.radius;
        } else {
            this.setNaN();
        }
    }

    public boolean isNaN() {
        return this.center.isNaN() || Double.isNaN(this.radius);
    }

    public double getVolume() {
        return 4.1887902047863905 * this.radius * this.radius * this.radius;
    }

    public void scale(Matrix3x3 m) {
        m.transform(this.center);
        double xScaleSquared = Tuple3.calculateMagnitudeSquared(m.right.x, m.right.y, m.right.z);
        double yScaleSquared = Tuple3.calculateMagnitudeSquared(m.up.x, m.up.y, m.up.z);
        double zScaleSquared = Tuple3.calculateMagnitudeSquared(m.backward.x, m.backward.y, m.backward.z);
        double scaleSquared = Math.max(xScaleSquared, Math.max(yScaleSquared, zScaleSquared));
        this.radius *= Math.sqrt(scaleSquared);
    }

    public String toString() {
        return "edu.cmu.cs.dennisc.math.Sphere[radius=" + this.radius + ",center=" + this.center + "]";
    }
}

