/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

public abstract class Tuple2f
implements BinaryEncodableAndDecodable,
Printable {
    public float x = 0.0f;
    public float y = 0.0f;

    public Tuple2f() {
    }

    public Tuple2f(Tuple2f other) {
        this.set(other);
    }

    public Tuple2f(float x, float y) {
        this.set(x, y);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.x = binaryDecoder.decodeFloat();
        this.y = binaryDecoder.decodeFloat();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.x);
        binaryEncoder.encode(this.y);
    }

    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        if (isLines) {
            rv.append("+-       -+\n");
            rv.append("| ");
        }
        rv.append(decimalFormat.format(this.x));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.y));
        if (isLines) {
            rv.append(" |\n");
            rv.append("+-       -+\n");
        }
        return rv;
    }

    public boolean isWithinEpsilonOf(Tuple2f other, float epsilon) {
        return EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.x), other.x, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.y), other.y, epsilon);
    }

    public boolean isWithinReasonableEpsilonOf(Tuple2f other) {
        return this.isWithinEpsilonOf(other, 0.001f);
    }

    public boolean isWithinEpsilonOfUnitLengthSquared(float epsilon) {
        return EpsilonUtilities.isWithinEpsilonOf1InSquaredSpace(this.calculateMagnitudeSquared(), epsilon);
    }

    public boolean isWithinReasonableEpsilonOfUnitLengthSquared() {
        return this.isWithinEpsilonOfUnitLengthSquared(0.001f);
    }

    public void set(Tuple2f other) {
        if (other != null) {
            this.x = other.x;
            this.y = other.y;
        } else {
            this.setNaN();
        }
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public static Tuple2f setReturnValueToZero(Tuple2f rv) {
        rv.y = 0.0f;
        rv.x = 0.0f;
        return rv;
    }

    public void setZero() {
        Tuple2f.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f;
    }

    public static Tuple2f setReturnValueToNaN(Tuple2f rv) {
        rv.y = Float.NaN;
        rv.x = Float.NaN;
        return rv;
    }

    public void setNaN() {
        Tuple2f.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) && Float.isNaN(this.y);
    }

    public static Tuple2f setReturnValueToAddition(Tuple2f rv, Tuple2f a, Tuple2f b) {
        rv.x = a.x + b.x;
        rv.y = a.y + b.y;
        return rv;
    }

    public void setToAddition(Tuple2f a, Tuple2f b) {
        Tuple2f.setReturnValueToAddition(this, a, b);
    }

    public void add(Tuple2f b) {
        this.setToAddition(this, b);
    }

    public static Tuple2f setReturnValueToSubtraction(Tuple2f rv, Tuple2f a, Tuple2f b) {
        rv.x = a.x - b.x;
        rv.y = a.y - b.y;
        return rv;
    }

    public void setToSubtraction(Tuple2f a, Tuple2f b) {
        Tuple2f.setReturnValueToSubtraction(this, a, b);
    }

    public void subtract(Tuple2f b) {
        this.setToSubtraction(this, b);
    }

    public static Tuple2f setReturnValueToNegation(Tuple2f rv, Tuple2f a) {
        rv.x = -a.x;
        rv.y = -a.y;
        return rv;
    }

    public void setToNegation(Tuple2f a) {
        Tuple2f.setReturnValueToNegation(this, a);
    }

    public void negate() {
        this.setToNegation(this);
    }

    public static Tuple2f setReturnValueToMultiplication(Tuple2f rv, Tuple2f a, Tuple2f b) {
        rv.x = a.x * b.x;
        rv.y = a.y * b.y;
        return rv;
    }

    public void setToMultiplication(Tuple2f a, Tuple2f b) {
        Tuple2f.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(Tuple2f b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple2f setReturnValueToMultiplication(Tuple2f rv, Tuple2f a, float b) {
        rv.x = a.x * b;
        rv.y = a.y * b;
        return rv;
    }

    public void setToMultiplication(Tuple2f a, float b) {
        Tuple2f.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(float b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple2f setReturnValueToDivision(Tuple2f rv, Tuple2f a, Tuple2f b) {
        rv.x = a.x / b.x;
        rv.y = a.y / b.y;
        return rv;
    }

    public void setToDivision(Tuple2f a, Tuple2f b) {
        Tuple2f.setReturnValueToDivision(this, a, b);
    }

    public void divide(Tuple2f b) {
        this.setToDivision(this, b);
    }

    public static Tuple2f setReturnValueToDivision(Tuple2f rv, Tuple2f a, float b) {
        rv.x = a.x / b;
        rv.y = a.y / b;
        return rv;
    }

    public void setToDivision(Tuple2f a, float b) {
        Tuple2f.setReturnValueToDivision(this, a, b);
    }

    public void divide(float b) {
        this.setToDivision(this, b);
    }

    public static Tuple2f setReturnValueToInterpolation(Tuple2f rv, Tuple2f a, Tuple2f b, float portion) {
        rv.x = a.x + (b.x - a.x) * portion;
        rv.y = a.y + (b.y - a.y) * portion;
        return rv;
    }

    public void setToInterpolation(Tuple2f a, Tuple2f b, float portion) {
        Tuple2f.setReturnValueToInterpolation(this, a, b, portion);
    }

    public static float calculateMagnitudeSquared(float x, float y) {
        return x * x + y * y;
    }

    public static float calculateMagnitude(float x, float y) {
        float magnitudeSquared = Tuple2f.calculateMagnitudeSquared(x, y);
        if (magnitudeSquared == 1.0f) {
            return 1.0f;
        }
        return (float)Math.sqrt(magnitudeSquared);
    }

    public float calculateMagnitudeSquared() {
        return Tuple2f.calculateMagnitudeSquared(this.x, this.y);
    }

    public float calculateMagnitude() {
        return Tuple2f.calculateMagnitude(this.x, this.y);
    }

    public static Tuple2f setReturnValueToNormalized(Tuple2f rv, Tuple2f a) {
        rv.set(a);
        float magnitudeSquared = rv.calculateMagnitudeSquared();
        if ((double)magnitudeSquared != 1.0) {
            rv.divide((float)Math.sqrt(magnitudeSquared));
        }
        return rv;
    }

    public void setToNormalized(Tuple2f a) {
        Tuple2f.setReturnValueToNormalized(this, a);
    }

    public void normalize() {
        this.setToNormalized(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (this.getClass().equals(o.getClass())) {
                Tuple2f other = (Tuple2f)o;
                return Float.compare(this.x, other.x) == 0 && Float.compare(this.y, other.y) == 0;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        int rv = 17;
        rv = 37 * rv + this.getClass().hashCode();
        rv = 37 * rv + Float.floatToIntBits(this.x);
        rv = 37 * rv + Float.floatToIntBits(this.y);
        return rv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(";y=");
        sb.append(this.y);
        sb.append("]");
        return sb.toString();
    }
}

