/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

public abstract class Tuple3
implements BinaryEncodableAndDecodable,
Printable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public Tuple3() {
    }

    public Tuple3(Tuple3 other) {
        this.set(other);
    }

    public Tuple3(double x, double y, double z) {
        this.set(x, y, z);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.x = binaryDecoder.decodeDouble();
        this.y = binaryDecoder.decodeDouble();
        this.z = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.x);
        binaryEncoder.encode(this.y);
        binaryEncoder.encode(this.z);
    }

    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        if (isLines) {
            rv.append("+-       -+\n");
            rv.append("| ");
        }
        rv.append(decimalFormat.format(this.x));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.y));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.z));
        if (isLines) {
            rv.append(" |\n");
            rv.append("+-       -+\n");
        }
        return rv;
    }

    public boolean isWithinEpsilonOf(Tuple3 other, double epsilon) {
        return EpsilonUtilities.isWithinEpsilon((Number)this.x, other.x, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.y, other.y, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.z, other.z, epsilon);
    }

    public boolean isWithinReasonableEpsilonOf(Tuple3 other) {
        return this.isWithinEpsilonOf(other, 0.001);
    }

    public boolean isWithinEpsilonOfUnitLengthSquared(double epsilon) {
        return EpsilonUtilities.isWithinEpsilonOf1InSquaredSpace(this.calculateMagnitudeSquared(), epsilon);
    }

    public boolean isWithinReasonableEpsilonOfUnitLengthSquared() {
        return this.isWithinEpsilonOfUnitLengthSquared(0.001);
    }

    public void set(Tuple3 other) {
        if (other != null) {
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
        } else {
            this.setNaN();
        }
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Tuple3 setReturnValueToZero(Tuple3 rv) {
        rv.z = 0.0;
        rv.y = 0.0;
        rv.x = 0.0;
        return rv;
    }

    public void setZero() {
        Tuple3.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public static Tuple3 setReturnValueToNaN(Tuple3 rv) {
        rv.z = Double.NaN;
        rv.y = Double.NaN;
        rv.x = Double.NaN;
        return rv;
    }

    public void setNaN() {
        Tuple3.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) && Double.isNaN(this.y) && Double.isNaN(this.z);
    }

    public static Tuple3 setReturnValueToAddition(Tuple3 rv, Tuple3 a, Tuple3 b) {
        rv.x = a.x + b.x;
        rv.y = a.y + b.y;
        rv.z = a.z + b.z;
        return rv;
    }

    public void setToAddition(Tuple3 a, Tuple3 b) {
        Tuple3.setReturnValueToAddition(this, a, b);
    }

    public void add(Tuple3 b) {
        this.setToAddition(this, b);
    }

    public static Tuple3 setReturnValueToSubtraction(Tuple3 rv, Tuple3 a, Tuple3 b) {
        rv.x = a.x - b.x;
        rv.y = a.y - b.y;
        rv.z = a.z - b.z;
        return rv;
    }

    public void setToSubtraction(Tuple3 a, Tuple3 b) {
        Tuple3.setReturnValueToSubtraction(this, a, b);
    }

    public void subtract(Tuple3 b) {
        this.setToSubtraction(this, b);
    }

    public static Tuple3 setReturnValueToNegation(Tuple3 rv, Tuple3 a) {
        rv.x = -a.x;
        rv.y = -a.y;
        rv.z = -a.z;
        return rv;
    }

    public void setToNegation(Tuple3 a) {
        Tuple3.setReturnValueToNegation(this, a);
    }

    public void negate() {
        this.setToNegation(this);
    }

    public static Tuple3 setReturnValueToMultiplication(Tuple3 rv, Tuple3 a, Tuple3 b) {
        rv.x = a.x * b.x;
        rv.y = a.y * b.y;
        rv.z = a.z * b.z;
        return rv;
    }

    public void setToMultiplication(Tuple3 a, Tuple3 b) {
        Tuple3.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(Tuple3 b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple3 setReturnValueToMultiplication(Tuple3 rv, Tuple3 a, double b) {
        rv.x = a.x * b;
        rv.y = a.y * b;
        rv.z = a.z * b;
        return rv;
    }

    public void setToMultiplication(Tuple3 a, double b) {
        Tuple3.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(double b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple3 setReturnValueToDivision(Tuple3 rv, Tuple3 a, Tuple3 b) {
        rv.x = a.x / b.x;
        rv.y = a.y / b.y;
        rv.z = a.z / b.z;
        return rv;
    }

    public void setToDivision(Tuple3 a, Tuple3 b) {
        Tuple3.setReturnValueToDivision(this, a, b);
    }

    public void divide(Tuple3 b) {
        this.setToDivision(this, b);
    }

    public static Tuple3 setReturnValueToDivision(Tuple3 rv, Tuple3 a, double b) {
        rv.x = a.x / b;
        rv.y = a.y / b;
        rv.z = a.z / b;
        return rv;
    }

    public void setToDivision(Tuple3 a, double b) {
        Tuple3.setReturnValueToDivision(this, a, b);
    }

    public void divide(double b) {
        this.setToDivision(this, b);
    }

    public static Tuple3 setReturnValueToInterpolation(Tuple3 rv, Tuple3 a, Tuple3 b, double portion) {
        rv.x = a.x + (b.x - a.x) * portion;
        rv.y = a.y + (b.y - a.y) * portion;
        rv.z = a.z + (b.z - a.z) * portion;
        return rv;
    }

    public void setToInterpolation(Tuple3 a, Tuple3 b, double portion) {
        Tuple3.setReturnValueToInterpolation(this, a, b, portion);
    }

    public static double calculateMagnitudeSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double calculateMagnitude(double x, double y, double z) {
        double magnitudeSquared = Tuple3.calculateMagnitudeSquared(x, y, z);
        if (magnitudeSquared == 1.0) {
            return 1.0;
        }
        return Math.sqrt(magnitudeSquared);
    }

    public double calculateMagnitudeSquared() {
        return Tuple3.calculateMagnitudeSquared(this.x, this.y, this.z);
    }

    public double calculateMagnitude() {
        return Tuple3.calculateMagnitude(this.x, this.y, this.z);
    }

    public static Tuple3 setReturnValueToNormalized(Tuple3 rv, Tuple3 a) {
        rv.set(a);
        double magnitudeSquared = rv.calculateMagnitudeSquared();
        if (magnitudeSquared != 1.0) {
            rv.divide(Math.sqrt(magnitudeSquared));
        }
        return rv;
    }

    public void setToNormalized(Tuple3 a) {
        Tuple3.setReturnValueToNormalized(this, a);
    }

    public void normalize() {
        this.setToNormalized(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (this.getClass().equals(o.getClass())) {
                Tuple3 other = (Tuple3)o;
                return Double.compare(this.x, other.x) == 0 && Double.compare(this.y, other.y) == 0 && Double.compare(this.z, other.z) == 0;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        int rv = 17;
        rv = 37 * rv + this.getClass().hashCode();
        long lng = Double.doubleToLongBits(this.x);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        lng = Double.doubleToLongBits(this.y);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        lng = Double.doubleToLongBits(this.z);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        return rv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(";y=");
        sb.append(this.y);
        sb.append(";z=");
        sb.append(this.z);
        sb.append("]");
        return sb.toString();
    }
}

