/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

public abstract class Tuple4f
implements BinaryEncodableAndDecodable,
Printable {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public float w = 0.0f;

    public Tuple4f() {
    }

    public Tuple4f(Tuple4f other) {
        this.set(other);
    }

    public Tuple4f(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.x = binaryDecoder.decodeFloat();
        this.y = binaryDecoder.decodeFloat();
        this.z = binaryDecoder.decodeFloat();
        this.w = binaryDecoder.decodeFloat();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.x);
        binaryEncoder.encode(this.y);
        binaryEncoder.encode(this.z);
        binaryEncoder.encode(this.w);
    }

    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        if (isLines) {
            rv.append("+-       -+\n");
            rv.append("| ");
        }
        rv.append(decimalFormat.format(this.x));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.y));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.z));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.w));
        if (isLines) {
            rv.append(" |\n");
            rv.append("+-       -+\n");
        }
        return rv;
    }

    public boolean isWithinEpsilonOf(Tuple4f other, float epsilon) {
        return EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.x), other.x, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.y), other.y, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.z), other.z, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.w), other.w, epsilon);
    }

    public boolean isWithinReasonableEpsilonOf(Tuple4f other) {
        return this.isWithinEpsilonOf(other, 0.001f);
    }

    public boolean isWithinEpsilonOfUnitLengthSquared(float epsilon) {
        return EpsilonUtilities.isWithinEpsilonOf1InSquaredSpace(this.calculateMagnitudeSquared(), epsilon);
    }

    public boolean isWithinReasonableEpsilonOfUnitLengthSquared() {
        return this.isWithinEpsilonOfUnitLengthSquared(0.001f);
    }

    public void set(Tuple4f other) {
        if (other != null) {
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
            this.w = other.w;
        } else {
            this.setNaN();
        }
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public static Tuple4f setReturnValueToZero(Tuple4f rv) {
        rv.w = 0.0f;
        rv.z = 0.0f;
        rv.y = 0.0f;
        rv.x = 0.0f;
        return rv;
    }

    public void setZero() {
        Tuple4f.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f && this.w == 0.0f;
    }

    public static Tuple4f setReturnValueToNaN(Tuple4f rv) {
        rv.w = Float.NaN;
        rv.z = Float.NaN;
        rv.y = Float.NaN;
        rv.x = Float.NaN;
        return rv;
    }

    public void setNaN() {
        Tuple4f.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) && Float.isNaN(this.y) && Float.isNaN(this.z) && Float.isNaN(this.w);
    }

    public static Tuple4f setReturnValueToAddition(Tuple4f rv, Tuple4f a, Tuple4f b) {
        rv.x = a.x + b.x;
        rv.y = a.y + b.y;
        rv.z = a.z + b.z;
        rv.w = a.w + b.w;
        return rv;
    }

    public void setToAddition(Tuple4f a, Tuple4f b) {
        Tuple4f.setReturnValueToAddition(this, a, b);
    }

    public void add(Tuple4f b) {
        this.setToAddition(this, b);
    }

    public static Tuple4f setReturnValueToSubtraction(Tuple4f rv, Tuple4f a, Tuple4f b) {
        rv.x = a.x - b.x;
        rv.y = a.y - b.y;
        rv.z = a.z - b.z;
        rv.w = a.w - b.w;
        return rv;
    }

    public void setToSubtraction(Tuple4f a, Tuple4f b) {
        Tuple4f.setReturnValueToSubtraction(this, a, b);
    }

    public void subtract(Tuple4f b) {
        this.setToSubtraction(this, b);
    }

    public static Tuple4f setReturnValueToNegation(Tuple4f rv, Tuple4f a) {
        rv.x = -a.x;
        rv.y = -a.y;
        rv.z = -a.z;
        rv.w = -a.w;
        return rv;
    }

    public void setToNegation(Tuple4f a) {
        Tuple4f.setReturnValueToNegation(this, a);
    }

    public void negate() {
        this.setToNegation(this);
    }

    public static Tuple4f setReturnValueToMultiplication(Tuple4f rv, Tuple4f a, Tuple4f b) {
        rv.x = a.x * b.x;
        rv.y = a.y * b.y;
        rv.z = a.z * b.z;
        rv.w = a.w * b.w;
        return rv;
    }

    public void setToMultiplication(Tuple4f a, Tuple4f b) {
        Tuple4f.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(Tuple4f b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple4f setReturnValueToMultiplication(Tuple4f rv, Tuple4f a, float b) {
        rv.x = a.x * b;
        rv.y = a.y * b;
        rv.z = a.z * b;
        rv.w = a.w * b;
        return rv;
    }

    public void setToMultiplication(Tuple4f a, float b) {
        Tuple4f.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(float b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple4f setReturnValueToDivision(Tuple4f rv, Tuple4f a, Tuple4f b) {
        rv.x = a.x / b.x;
        rv.y = a.y / b.y;
        rv.z = a.z / b.z;
        rv.w = a.w / b.w;
        return rv;
    }

    public void setToDivision(Tuple4f a, Tuple4f b) {
        Tuple4f.setReturnValueToDivision(this, a, b);
    }

    public void divide(Tuple4f b) {
        this.setToDivision(this, b);
    }

    public static Tuple4f setReturnValueToDivision(Tuple4f rv, Tuple4f a, float b) {
        rv.x = a.x / b;
        rv.y = a.y / b;
        rv.z = a.z / b;
        rv.w = a.w / b;
        return rv;
    }

    public void setToDivision(Tuple4f a, float b) {
        Tuple4f.setReturnValueToDivision(this, a, b);
    }

    public void divide(float b) {
        this.setToDivision(this, b);
    }

    public static Tuple4f setReturnValueToInterpolation(Tuple4f rv, Tuple4f a, Tuple4f b, float portion) {
        rv.x = a.x + (b.x - a.x) * portion;
        rv.y = a.y + (b.y - a.y) * portion;
        rv.z = a.z + (b.z - a.z) * portion;
        rv.w = a.w + (b.w - a.w) * portion;
        return rv;
    }

    public void setToInterpolation(Tuple4f a, Tuple4f b, float portion) {
        Tuple4f.setReturnValueToInterpolation(this, a, b, portion);
    }

    public static float calculateMagnitudeSquared(float x, float y, float z, float w) {
        return x * x + y * y + z * z + w * w;
    }

    public static float calculateMagnitude(float x, float y, float z, float w) {
        float magnitudeSquared = Tuple4f.calculateMagnitudeSquared(x, y, z, w);
        if ((double)magnitudeSquared == 1.0) {
            return 1.0f;
        }
        return (float)Math.sqrt(magnitudeSquared);
    }

    public float calculateMagnitudeSquared() {
        return Tuple4f.calculateMagnitudeSquared(this.x, this.y, this.z, this.w);
    }

    public float calculateMagnitude() {
        return Tuple4f.calculateMagnitude(this.x, this.y, this.z, this.w);
    }

    public static Tuple4f setReturnValueToNormalized(Tuple4f rv, Tuple4f a) {
        rv.set(a);
        float magnitudeSquared = rv.calculateMagnitudeSquared();
        if ((double)magnitudeSquared != 1.0) {
            rv.divide((float)Math.sqrt(magnitudeSquared));
        }
        return rv;
    }

    public void setToNormalized(Tuple4f a) {
        Tuple4f.setReturnValueToNormalized(this, a);
    }

    public void normalize() {
        this.setToNormalized(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (this.getClass().equals(o.getClass())) {
                Tuple4f other = (Tuple4f)o;
                return Float.compare(this.x, other.x) == 0 && Float.compare(this.y, other.y) == 0 && Float.compare(this.z, other.z) == 0 && Float.compare(this.w, other.w) == 0;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        int rv = 17;
        rv = 37 * rv + this.getClass().hashCode();
        rv = 37 * rv + Float.floatToIntBits(this.x);
        rv = 37 * rv + Float.floatToIntBits(this.y);
        rv = 37 * rv + Float.floatToIntBits(this.z);
        rv = 37 * rv + Float.floatToIntBits(this.w);
        return rv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(";y=");
        sb.append(this.y);
        sb.append(";z=");
        sb.append(this.z);
        sb.append(";w=");
        sb.append(this.w);
        sb.append("]");
        return sb.toString();
    }
}

