/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.AxisRotation;
import edu.cmu.cs.dennisc.math.EulerAngles;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

public class UnitQuaternion
implements Orientation,
BinaryEncodableAndDecodable,
Printable {
    public double x = Double.NaN;
    public double y = Double.NaN;
    public double z = Double.NaN;
    public double w = Double.NaN;
    private static final UnitQuaternion IDENTITY = UnitQuaternion.createNaN();

    private UnitQuaternion() {
    }

    public UnitQuaternion(double x, double y, double z, double w) {
        this.set(x, y, z, w);
    }

    public UnitQuaternion(OrthogonalMatrix3x3 other) {
        this.setValue(other);
    }

    public UnitQuaternion(UnitQuaternion other) {
        this.setValue(other);
    }

    public UnitQuaternion(AxisRotation other) {
        this.setValue(other);
    }

    public UnitQuaternion(EulerAngles other) {
        this.setValue(other);
    }

    public UnitQuaternion(ForwardAndUpGuide other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3 createOrthogonalMatrix3x3() {
        return new OrthogonalMatrix3x3(this);
    }

    public UnitQuaternion createUnitQuaternion() {
        return new UnitQuaternion(this);
    }

    public AxisRotation createAxisRotation() {
        return new AxisRotation(this);
    }

    public EulerAngles createEulerAngles() {
        return new EulerAngles(this);
    }

    public ForwardAndUpGuide createForwardAndUpGuide() {
        return new ForwardAndUpGuide(this);
    }

    public OrthogonalMatrix3x3 getValue(OrthogonalMatrix3x3 rv) {
        rv.setValue(this);
        return rv;
    }

    public UnitQuaternion getValue(UnitQuaternion rv) {
        rv.setValue(this);
        return rv;
    }

    public AxisRotation getValue(AxisRotation rv) {
        rv.setValue(this);
        return rv;
    }

    public EulerAngles getValue(EulerAngles rv) {
        rv.setValue(this);
        return rv;
    }

    public ForwardAndUpGuide getValue(ForwardAndUpGuide rv) {
        rv.setValue(this);
        return rv;
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.x = binaryDecoder.decodeDouble();
        this.y = binaryDecoder.decodeDouble();
        this.z = binaryDecoder.decodeDouble();
        this.w = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.x);
        binaryEncoder.encode(this.y);
        binaryEncoder.encode(this.z);
        binaryEncoder.encode(this.w);
    }

    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        if (isLines) {
            rv.append("+-       -+\n");
            rv.append("| ");
        }
        rv.append(decimalFormat.format(this.x));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.y));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.z));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.w));
        if (isLines) {
            rv.append(" |\n");
            rv.append("+-       -+q\n");
        }
        return rv;
    }

    public static UnitQuaternion setReturnValueToNaN(UnitQuaternion rv) {
        rv.w = Double.NaN;
        rv.z = Double.NaN;
        rv.y = Double.NaN;
        rv.x = Double.NaN;
        return rv;
    }

    public static UnitQuaternion createNaN() {
        return UnitQuaternion.setReturnValueToNaN(new UnitQuaternion());
    }

    public void setNaN() {
        UnitQuaternion.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z) || Double.isNaN(this.w);
    }

    public static UnitQuaternion accessIdentity() {
        IDENTITY.setIdentity();
        return IDENTITY;
    }

    public static UnitQuaternion setReturnValueToIdentity(UnitQuaternion rv) {
        rv.z = 0.0;
        rv.y = 0.0;
        rv.x = 0.0;
        rv.w = 1.0;
        return rv;
    }

    public static UnitQuaternion createIdentity() {
        return UnitQuaternion.setReturnValueToIdentity(UnitQuaternion.createNaN());
    }

    public void setIdentity() {
        UnitQuaternion.setReturnValueToIdentity(this);
    }

    public boolean isIdentity() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.w == 1.0;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof UnitQuaternion) {
            UnitQuaternion q = (UnitQuaternion)obj;
            return this.x == q.x && this.y == q.y && this.z == q.z && this.w == q.w;
        }
        return false;
    }

    public boolean isWithinEpsilon(UnitQuaternion q, double epsilon) {
        return Math.abs(this.x - q.x) < epsilon && Math.abs(this.y - q.y) < epsilon && Math.abs(this.z - q.z) < epsilon && Math.abs(this.w - q.w) < epsilon;
    }

    public void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void setValue(OrthogonalMatrix3x3 m) {
        if (!m.isWithinReasonableEpsilonOfUnitLengthSquared()) {
            PrintUtilities.println("WARNING: UnitQuaternion set to non-unit Matrix3x3");
            PrintUtilities.printlns(m);
            PrintUtilities.println("right magnitude:   ", m.right.calculateMagnitude());
            PrintUtilities.println("up magnitude:      ", m.up.calculateMagnitude());
            PrintUtilities.println("backward magnitude:", m.backward.calculateMagnitude());
            PrintUtilities.println();
        }
        this.setValue(new AxisRotation(m));
    }

    public void setValue(UnitQuaternion other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.w = other.w;
    }

    public void setValue(AxisRotation aa) {
        double halfThetaInRadians = aa.angle.getAsRadians() * 0.5;
        double c = Math.cos(halfThetaInRadians);
        double s = Math.sin(halfThetaInRadians);
        this.w = c;
        this.x = aa.axis.x * s;
        this.y = aa.axis.y * s;
        this.z = aa.axis.z * s;
    }

    public void setValue(EulerAngles ea) {
        this.setValue(new AxisRotation(ea));
    }

    public void setValue(ForwardAndUpGuide faug) {
        this.setValue(new AxisRotation(faug));
    }

    public static UnitQuaternion setReturnValueToAddition(UnitQuaternion rv, UnitQuaternion a, UnitQuaternion b) {
        rv.x = a.x + b.x;
        rv.y = a.y + b.y;
        rv.z = a.z + b.z;
        rv.w = a.w + b.w;
        return rv;
    }

    public static UnitQuaternion createAddition(UnitQuaternion a, UnitQuaternion b) {
        return UnitQuaternion.setReturnValueToAddition(UnitQuaternion.createNaN(), a, b);
    }

    public void setToAddition(UnitQuaternion a, UnitQuaternion b) {
        UnitQuaternion.setReturnValueToAddition(this, a, b);
    }

    public void add(UnitQuaternion b) {
        this.setToAddition(this, b);
    }

    public static UnitQuaternion setReturnValueToSubtraction(UnitQuaternion rv, UnitQuaternion a, UnitQuaternion b) {
        rv.x = a.x - b.x;
        rv.y = a.y - b.y;
        rv.z = a.z - b.z;
        rv.w = a.w - b.w;
        return rv;
    }

    public static UnitQuaternion createSubtraction(UnitQuaternion a, UnitQuaternion b) {
        return UnitQuaternion.setReturnValueToSubtraction(UnitQuaternion.createNaN(), a, b);
    }

    public void setToSubtraction(UnitQuaternion a, UnitQuaternion b) {
        UnitQuaternion.setReturnValueToSubtraction(this, a, b);
    }

    public void subtract(UnitQuaternion b) {
        this.setToSubtraction(this, b);
    }

    public static UnitQuaternion setReturnValueToNegation(UnitQuaternion rv, UnitQuaternion a) {
        rv.x = -a.x;
        rv.y = -a.y;
        rv.z = -a.z;
        rv.w = -a.w;
        return rv;
    }

    public static UnitQuaternion createNegation(UnitQuaternion a) {
        return UnitQuaternion.setReturnValueToNegation(UnitQuaternion.createNaN(), a);
    }

    public void setToNegation(UnitQuaternion a) {
        UnitQuaternion.setReturnValueToNegation(this, a);
    }

    public void negate() {
        this.setToNegation(this);
    }

    public static UnitQuaternion setReturnValueToMultiplication(UnitQuaternion rv, UnitQuaternion a, UnitQuaternion b) {
        throw new RuntimeException("TODO");
    }

    public static UnitQuaternion createMultiplication(UnitQuaternion a, UnitQuaternion b) {
        return UnitQuaternion.setReturnValueToMultiplication(UnitQuaternion.createNaN(), a, b);
    }

    public void setToMultiplication(UnitQuaternion a, UnitQuaternion b) {
        UnitQuaternion.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(UnitQuaternion b) {
        this.setToMultiplication(this, b);
    }

    public static UnitQuaternion setReturnValueToMultiplication(UnitQuaternion rv, UnitQuaternion a, double b) {
        rv.x = a.x * b;
        rv.y = a.y * b;
        rv.z = a.z * b;
        rv.w = a.w * b;
        return rv;
    }

    public static UnitQuaternion createMultiplication(UnitQuaternion a, double b) {
        return UnitQuaternion.setReturnValueToMultiplication(UnitQuaternion.createNaN(), a, b);
    }

    public void setToMultiplication(UnitQuaternion a, double b) {
        UnitQuaternion.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(double b) {
        this.setToMultiplication(this, b);
    }

    public static UnitQuaternion setReturnValueToDivision(UnitQuaternion rv, UnitQuaternion a, double b) {
        rv.x = a.x / b;
        rv.y = a.y / b;
        rv.z = a.z / b;
        rv.w = a.w / b;
        return rv;
    }

    public static UnitQuaternion createDivision(UnitQuaternion a, double b) {
        return UnitQuaternion.setReturnValueToDivision(UnitQuaternion.createNaN(), a, b);
    }

    public void setToDivision(UnitQuaternion a, double b) {
        UnitQuaternion.setReturnValueToDivision(this, a, b);
    }

    public void divide(double b) {
        this.setToDivision(this, b);
    }

    public static UnitQuaternion setReturnValueToInterpolation(UnitQuaternion rv, UnitQuaternion a, UnitQuaternion b, double portion) {
        double EPSILON = 1.0E-4;
        assert (!a.isNaN());
        assert (!b.isNaN());
        if (portion == 0.0) {
            rv.setValue(a);
        } else if (portion == 1.0) {
            rv.setValue(b);
        } else if (a.isWithinEpsilon(b, 1.0E-4)) {
            rv.setValue(b);
        } else {
            double bPortion;
            double aPortion;
            double b_w;
            double b_z;
            double b_y;
            double b_x;
            double dotProduct = a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
            if (dotProduct < 0.0) {
                b_x = -b.x;
                b_y = -b.y;
                b_z = -b.z;
                b_w = -b.w;
                dotProduct = -dotProduct;
            } else {
                b_x = b.x;
                b_y = b.y;
                b_z = b.z;
                b_w = b.w;
            }
            double THRESHOLD_TO_PERFORM_SIMPLE_LINEAR_INTERPOLATION = 0.05;
            if (1.0 - dotProduct < 0.05) {
                aPortion = 1.0 - portion;
                bPortion = portion;
            } else {
                double halfAngle = Math.acos(dotProduct);
                double sineHalfAngle = Math.sqrt(1.0 - dotProduct * dotProduct);
                aPortion = Math.sin((1.0 - portion) * halfAngle) / sineHalfAngle;
                bPortion = Math.sin(portion * halfAngle) / sineHalfAngle;
            }
            rv.x = a.x * aPortion + b_x * bPortion;
            rv.y = a.y * aPortion + b_y * bPortion;
            rv.z = a.z * aPortion + b_z * bPortion;
            rv.w = a.w * aPortion + b_w * bPortion;
        }
        assert (!rv.isNaN());
        return rv;
    }

    public static UnitQuaternion createInterpolation(UnitQuaternion a, UnitQuaternion b, double portion) {
        return UnitQuaternion.setReturnValueToInterpolation(new UnitQuaternion(), a, b, portion);
    }

    public void setToInterpolation(UnitQuaternion a, UnitQuaternion b, double portion) {
        UnitQuaternion.setReturnValueToInterpolation(this, a, b, portion);
    }

    public static double calculateMagnitudeSquared(double x, double y, double z, double w) {
        return x * x + y * y + z * z + w * w;
    }

    public static double calculateMagnitude(double x, double y, double z, double w) {
        double magnitudeSquared = UnitQuaternion.calculateMagnitudeSquared(x, y, z, w);
        if (magnitudeSquared == 1.0) {
            return 1.0;
        }
        return Math.sqrt(magnitudeSquared);
    }

    public double calculateMagnitudeSquared() {
        return UnitQuaternion.calculateMagnitudeSquared(this.x, this.y, this.z, this.w);
    }

    public double calculateMagnitude() {
        return UnitQuaternion.calculateMagnitude(this.x, this.y, this.z, this.w);
    }

    public static UnitQuaternion setReturnValueToNormalized(UnitQuaternion rv, UnitQuaternion a) {
        double magnitudeSquared = a.calculateMagnitudeSquared();
        if (magnitudeSquared != 1.0) {
            rv.divide(Math.sqrt(magnitudeSquared));
        }
        return rv;
    }

    public static UnitQuaternion createNormalized(UnitQuaternion a) {
        return UnitQuaternion.setReturnValueToNormalized(UnitQuaternion.createNaN(), a);
    }

    public void setToNormalized(UnitQuaternion a) {
        UnitQuaternion.setReturnValueToNormalized(this, a);
    }

    public void normalize() {
        this.setToNormalized(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(UnitQuaternion.class.getName());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(";y=");
        sb.append(this.y);
        sb.append(";z=");
        sb.append(this.z);
        sb.append(";w=");
        sb.append(this.w);
        sb.append("]");
        return sb.toString();
    }
}

